<?php
/**
 * Defines ViaClassmapSpec - specifications for Red61\Via\ViaClassmap
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via;

use Prophecy\Prophet;
use Red61\Via\ViaClassmap;
use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\ViaClassmap
 */
class ViaClassmapSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\ViaClassmap
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\ViaClassmap');
	}

	function it_has_array_of_data_class_names()
	{
		expect(ViaClassmap::$dataClassmap)->toBeArray();
	}

	function it_has_array_of_exception_class_names()
	{
		expect(ViaClassmap::$exceptionClassmap)->toBeArray();
	}

	function its_mapped_response_classes_can_be_constructed()
	{
		$prophet = new Prophet;
		foreach (ViaClassmap::$dataClassmap as $api_call => $fqcn) {
			$prophet->prophesize($fqcn);
		}
	}

	function its_mapped_exception_classes_can_be_constructed_and_are_soap_fault_and_via_exception()
	{
		$prophet = new Prophet;
		foreach (ViaClassmap::$exceptionClassmap as $detail => $fqcn) {
			$prophecy = $prophet->prophesize($fqcn);
			$exception = $prophecy->reveal();
			expect($exception)->toBeAnInstanceOf('\SoapFault');
			expect($exception)->toBeAnInstanceOf('\Red61\Via\Exception\ViaException');
		}
	}

}
