<?php
/**
 * Defines SOAP class mapping metadata in the ViaClassmap class.
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via;

/**
 * Defines the class mapping for SOAP result types into the VIA API classes. The SOAP client will use these class
 * mappings to create responses of the expected type. You can customise API response behaviour by extending the classes
 * supplied with the wrapper and passing in your own classmap to the VIA client.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here. Instead merge your custom mapping on top of the values provided here.
 *
 * @see        \Red61\Via\ApiClient.
 */
class ViaClassmap {

	/**
	 * @var string[]  keys are the SOAP class, values are the fully qualified PHP type
	 */
	public static $dataClassmap = array (
  'viaApiAccessNote' => '\\Red61\\Via\\DataObject\\ViaApiAccessNote',
  'viaApiAccessNoteCategory' => '\\Red61\\Via\\DataObject\\ViaApiAccessNoteCategory',
  'viaApiAccreditation' => '\\Red61\\Via\\DataObject\\ViaApiAccreditation',
  'viaApiAccreditationType' => '\\Red61\\Via\\DataObject\\ViaApiAccreditationType',
  'viaApiAddressDetails' => '\\Red61\\Via\\DataObject\\ViaApiAddressDetails',
  'viaApiAddressResult' => '\\Red61\\Via\\DataObject\\ViaApiAddressResult',
  'viaApiAgeSuitabilityDetails' => '\\Red61\\Via\\DataObject\\ViaApiAgeSuitabilityDetails',
  'viaApiAnsweredCompanyConsentQuestion' => '\\Red61\\Via\\DataObject\\ViaApiAnsweredCompanyConsentQuestion',
  'viaApiAnsweredConsentOption' => '\\Red61\\Via\\DataObject\\ViaApiAnsweredConsentOption',
  'viaApiAnsweredConsentQuestion' => '\\Red61\\Via\\DataObject\\ViaApiAnsweredConsentQuestion',
  'viaApiAttributeDetails' => '\\Red61\\Via\\DataObject\\ViaApiAttributeDetails',
  'viaApiAvailablePrintOptionReturn' => '\\Red61\\Via\\DataObject\\ViaApiAvailablePrintOptionReturn',
  'viaApiBaseTicketDetails' => '\\Red61\\Via\\DataObject\\ViaApiBaseTicketDetails',
  'viaApiBasket' => '\\Red61\\Via\\DataObject\\ViaApiBasket',
  'viaApiBasketDeliveryOptions' => '\\Red61\\Via\\DataObject\\ViaApiBasketDeliveryOptions',
  'viaApiBasketEventItem' => '\\Red61\\Via\\DataObject\\ViaApiBasketEventItem',
  'viaApiBasketFeeDetails' => '\\Red61\\Via\\DataObject\\ViaApiBasketFeeDetails',
  'viaApiBasketLimits' => '\\Red61\\Via\\DataObject\\ViaApiBasketLimits',
  'viaApiBasketPerformanceItem' => '\\Red61\\Via\\DataObject\\ViaApiBasketPerformanceItem',
  'viaApiBasketSubVenueItem' => '\\Red61\\Via\\DataObject\\ViaApiBasketSubVenueItem',
  'viaApiBasketSummary' => '\\Red61\\Via\\DataObject\\ViaApiBasketSummary',
  'viaApiBasketVenueItem' => '\\Red61\\Via\\DataObject\\ViaApiBasketVenueItem',
  'viaApiCardPaymentRequest' => '\\Red61\\Via\\DataObject\\ViaApiCardPaymentRequest',
  'viaApiCardType' => '\\Red61\\Via\\DataObject\\ViaApiCardType',
  'viaApiCompany' => '\\Red61\\Via\\DataObject\\ViaApiCompany',
  'viaApiCompanyConsentAnswers' => '\\Red61\\Via\\DataObject\\ViaApiCompanyConsentAnswers',
  'viaApiCompanyConsentQuestion' => '\\Red61\\Via\\DataObject\\ViaApiCompanyConsentQuestion',
  'viaApiConsentOption' => '\\Red61\\Via\\DataObject\\ViaApiConsentOption',
  'viaApiConsentQuestion' => '\\Red61\\Via\\DataObject\\ViaApiConsentQuestion',
  'viaApiConsentQuestionCore' => '\\Red61\\Via\\DataObject\\ViaApiConsentQuestionCore',
  'viaApiConsentQuestions' => '\\Red61\\Via\\DataObject\\ViaApiConsentQuestions',
  'viaApiCountryDetails' => '\\Red61\\Via\\DataObject\\ViaApiCountryDetails',
  'viaApiCreateDonationScheduleResponse' => '\\Red61\\Via\\DataObject\\ViaApiCreateDonationScheduleResponse',
  'viaApiCreatedMedia' => '\\Red61\\Via\\DataObject\\ViaApiCreatedMedia',
  'viaApiCustomCustomerFieldChoiceDetails' => '\\Red61\\Via\\DataObject\\ViaApiCustomCustomerFieldChoiceDetails',
  'viaApiCustomCustomerFieldDetails' => '\\Red61\\Via\\DataObject\\ViaApiCustomCustomerFieldDetails',
  'viaApiCustomEventDetails' => '\\Red61\\Via\\DataObject\\ViaApiCustomEventDetails',
  'viaApiCustomerCategory' => '\\Red61\\Via\\DataObject\\ViaApiCustomerCategory',
  'viaApiCustomerCompanyResponse' => '\\Red61\\Via\\DataObject\\ViaApiCustomerCompanyResponse',
  'viaApiCustomerConsentAnswer' => '\\Red61\\Via\\DataObject\\ViaApiCustomerConsentAnswer',
  'viaApiCustomerConsentQuestion' => '\\Red61\\Via\\DataObject\\ViaApiCustomerConsentQuestion',
  'viaApiCustomerConsentQuestions' => '\\Red61\\Via\\DataObject\\ViaApiCustomerConsentQuestions',
  'viaApiCustomerDetails' => '\\Red61\\Via\\DataObject\\ViaApiCustomerDetails',
  'viaApiCustomerEventInterest' => '\\Red61\\Via\\DataObject\\ViaApiCustomerEventInterest',
  'viaApiCustomerOtherDetails' => '\\Red61\\Via\\DataObject\\ViaApiCustomerOtherDetails',
  'viaApiCustomerPerformanceInterest' => '\\Red61\\Via\\DataObject\\ViaApiCustomerPerformanceInterest',
  'viaApiDeliveryOption' => '\\Red61\\Via\\DataObject\\ViaApiDeliveryOption',
  'viaApiDigitalEventPurchase' => '\\Red61\\Via\\DataObject\\ViaApiDigitalEventPurchase',
  'viaApiDigitalPerformancePurchase' => '\\Red61\\Via\\DataObject\\ViaApiDigitalPerformancePurchase',
  'viaApiDonationBasketItem' => '\\Red61\\Via\\DataObject\\ViaApiDonationBasketItem',
  'viaApiDonationDetails' => '\\Red61\\Via\\DataObject\\ViaApiDonationDetails',
  'viaApiDonationFund' => '\\Red61\\Via\\DataObject\\ViaApiDonationFund',
  'viaApiDonationScheduleSummary' => '\\Red61\\Via\\DataObject\\ViaApiDonationScheduleSummary',
  'viaApiDonationType' => '\\Red61\\Via\\DataObject\\ViaApiDonationType',
  'viaApiEvent' => '\\Red61\\Via\\DataObject\\ViaApiEvent',
  'viaApiEventFeeDetails' => '\\Red61\\Via\\DataObject\\ViaApiEventFeeDetails',
  'viaApiEventPerformance' => '\\Red61\\Via\\DataObject\\ViaApiEventPerformance',
  'viaApiFeeDetails' => '\\Red61\\Via\\DataObject\\ViaApiFeeDetails',
  'viaApiFeeForItemType' => '\\Red61\\Via\\DataObject\\ViaApiFeeForItemType',
  'viaApiFeeItemDetails' => '\\Red61\\Via\\DataObject\\ViaApiFeeItemDetails',
  'viaApiGiftAidDeclarationDetails' => '\\Red61\\Via\\DataObject\\ViaApiGiftAidDeclarationDetails',
  'viaApiGiftAidDeclarationFullDetails' => '\\Red61\\Via\\DataObject\\ViaApiGiftAidDeclarationFullDetails',
  'viaApiHPHPerformance' => '\\Red61\\Via\\DataObject\\ViaApiHPHPerformance',
  'viaApiImage' => '\\Red61\\Via\\DataObject\\ViaApiImage',
  'viaApiInsuranceQuoteDetails' => '\\Red61\\Via\\DataObject\\ViaApiInsuranceQuoteDetails',
  'viaApiItemRefundExemptRequest' => '\\Red61\\Via\\DataObject\\ViaApiItemRefundExemptRequest',
  'viaApiItemTypeFees' => '\\Red61\\Via\\DataObject\\ViaApiItemTypeFees',
  'viaApiKeyValuePair' => '\\Red61\\Via\\DataObject\\ViaApiKeyValuePair',
  'viaApiListElement' => '\\Red61\\Via\\DataObject\\ViaApiListElement',
  'viaApiListValue' => '\\Red61\\Via\\DataObject\\ViaApiListValue',
  'viaApiMedia' => '\\Red61\\Via\\DataObject\\ViaApiMedia',
  'viaApiMerchandise' => '\\Red61\\Via\\DataObject\\ViaApiMerchandise',
  'viaApiMerchandiseBasketItem' => '\\Red61\\Via\\DataObject\\ViaApiMerchandiseBasketItem',
  'viaApiMerchandiseCategory' => '\\Red61\\Via\\DataObject\\ViaApiMerchandiseCategory',
  'viaApiMerchandiseDetails' => '\\Red61\\Via\\DataObject\\ViaApiMerchandiseDetails',
  'viaApiMerchandiseVariation' => '\\Red61\\Via\\DataObject\\ViaApiMerchandiseVariation',
  'viaApiOfferPerformance' => '\\Red61\\Via\\DataObject\\ViaApiOfferPerformance',
  'viaApiOrderDetails' => '\\Red61\\Via\\DataObject\\ViaApiOrderDetails',
  'viaApiOrderPerformanceDetails' => '\\Red61\\Via\\DataObject\\ViaApiOrderPerformanceDetails',
  'viaApiPerformance' => '\\Red61\\Via\\DataObject\\ViaApiPerformance',
  'viaApiPerformanceAvailability' => '\\Red61\\Via\\DataObject\\ViaApiPerformanceAvailability',
  'viaApiPerformanceConcession' => '\\Red61\\Via\\DataObject\\ViaApiPerformanceConcession',
  'viaApiPerformanceDate' => '\\Red61\\Via\\DataObject\\ViaApiPerformanceDate',
  'viaApiPerformancePrice' => '\\Red61\\Via\\DataObject\\ViaApiPerformancePrice',
  'viaApiPerformancePrices' => '\\Red61\\Via\\DataObject\\ViaApiPerformancePrices',
  'viaApiPostageCharge' => '\\Red61\\Via\\DataObject\\ViaApiPostageCharge',
  'viaApiPrice' => '\\Red61\\Via\\DataObject\\ViaApiPrice',
  'viaApiPriceBandAvailibility' => '\\Red61\\Via\\DataObject\\ViaApiPriceBandAvailibility',
  'viaApiPriceConcession' => '\\Red61\\Via\\DataObject\\ViaApiPriceConcession',
  'viaApiProductDetails' => '\\Red61\\Via\\DataObject\\ViaApiProductDetails',
  'viaApiPurchaseSummary' => '\\Red61\\Via\\DataObject\\ViaApiPurchaseSummary',
  'viaApiQuestionResponse' => '\\Red61\\Via\\DataObject\\ViaApiQuestionResponse',
  'viaApiQuestionnaire' => '\\Red61\\Via\\DataObject\\ViaApiQuestionnaire',
  'viaApiQuestionnaireBasicQuestion' => '\\Red61\\Via\\DataObject\\ViaApiQuestionnaireBasicQuestion',
  'viaApiQuestionnaireQuestion' => '\\Red61\\Via\\DataObject\\ViaApiQuestionnaireQuestion',
  'viaApiQuestionnaireQuestionOption' => '\\Red61\\Via\\DataObject\\ViaApiQuestionnaireQuestionOption',
  'viaApiQuestionnaireResponse' => '\\Red61\\Via\\DataObject\\ViaApiQuestionnaireResponse',
  'viaApiQuestionnaireSection' => '\\Red61\\Via\\DataObject\\ViaApiQuestionnaireSection',
  'viaApiSavedCardDetails' => '\\Red61\\Via\\DataObject\\ViaApiSavedCardDetails',
  'viaApiSchemeDetails' => '\\Red61\\Via\\DataObject\\ViaApiSchemeDetails',
  'viaApiSchemeTierConcessionDetails' => '\\Red61\\Via\\DataObject\\ViaApiSchemeTierConcessionDetails',
  'viaApiSchemeTierDetails' => '\\Red61\\Via\\DataObject\\ViaApiSchemeTierDetails',
  'viaApiSchemeUsageDetails' => '\\Red61\\Via\\DataObject\\ViaApiSchemeUsageDetails',
  'viaApiScopeEntryDetails' => '\\Red61\\Via\\DataObject\\ViaApiScopeEntryDetails',
  'viaApiSeasonDetails' => '\\Red61\\Via\\DataObject\\ViaApiSeasonDetails',
  'viaApiSeatDetails' => '\\Red61\\Via\\DataObject\\ViaApiSeatDetails',
  'viaApiSubVenueDetails' => '\\Red61\\Via\\DataObject\\ViaApiSubVenueDetails',
  'viaApiSubscriptionBasketItem' => '\\Red61\\Via\\DataObject\\ViaApiSubscriptionBasketItem',
  'viaApiSubscriptionDetails' => '\\Red61\\Via\\DataObject\\ViaApiSubscriptionDetails',
  'viaApiTagDetails' => '\\Red61\\Via\\DataObject\\ViaApiTagDetails',
  'viaApiThreeDSecureV2BrowserInfo' => '\\Red61\\Via\\DataObject\\ViaApiThreeDSecureV2BrowserInfo',
  'viaApiTicketAttribute' => '\\Red61\\Via\\DataObject\\ViaApiTicketAttribute',
  'viaApiTicketAttributeRequest' => '\\Red61\\Via\\DataObject\\ViaApiTicketAttributeRequest',
  'viaApiTicketAttributeSelection' => '\\Red61\\Via\\DataObject\\ViaApiTicketAttributeSelection',
  'viaApiTicketDetails' => '\\Red61\\Via\\DataObject\\ViaApiTicketDetails',
  'viaApiTicketDetailsWithStatus' => '\\Red61\\Via\\DataObject\\ViaApiTicketDetailsWithStatus',
  'viaApiTicketItemDetails' => '\\Red61\\Via\\DataObject\\ViaApiTicketItemDetails',
  'viaApiTicketItemDetailsWithStatus' => '\\Red61\\Via\\DataObject\\ViaApiTicketItemDetailsWithStatus',
  'viaApiTicketRequest' => '\\Red61\\Via\\DataObject\\ViaApiTicketRequest',
  'viaApiTransactionDetails' => '\\Red61\\Via\\DataObject\\ViaApiTransactionDetails',
  'viaApiTransactionEventFeeDetails' => '\\Red61\\Via\\DataObject\\ViaApiTransactionEventFeeDetails',
  'viaApiTransactionFeeDetails' => '\\Red61\\Via\\DataObject\\ViaApiTransactionFeeDetails',
  'viaApiTransactionPaymentDetails' => '\\Red61\\Via\\DataObject\\ViaApiTransactionPaymentDetails',
  'viaApiTransactionSummary' => '\\Red61\\Via\\DataObject\\ViaApiTransactionSummary',
  'viaApiTypeListElement' => '\\Red61\\Via\\DataObject\\ViaApiTypeListElement',
  'viaApiVenueDetails' => '\\Red61\\Via\\DataObject\\ViaApiVenueDetails',
  'viaApiVoucherDetails' => '\\Red61\\Via\\DataObject\\ViaApiVoucherDetails',
  'viaApiVoucherGiftDetails' => '\\Red61\\Via\\DataObject\\ViaApiVoucherGiftDetails',
  'viaApiVoucherRedeemBasketItem' => '\\Red61\\Via\\DataObject\\ViaApiVoucherRedeemBasketItem',
  'viaApiVoucherType' => '\\Red61\\Via\\DataObject\\ViaApiVoucherType',
  'viaApiVoucherTypeBasketItem' => '\\Red61\\Via\\DataObject\\ViaApiVoucherTypeBasketItem',
);

	/**
	 * @var string[]  keys are the SOAP class, values are the fully qualified PHP type
	 */
	public static $exceptionClassmap = array (
  'AccessNotesException' => '\\Red61\\Via\\Exception\\AccessNotesException',
  'AddSeatsException' => '\\Red61\\Via\\Exception\\AddSeatsException',
  'BadCustomerException' => '\\Red61\\Via\\Exception\\BadCustomerException',
  'BasketChangedException' => '\\Red61\\Via\\Exception\\BasketChangedException',
  'CartNotFoundException' => '\\Red61\\Via\\Exception\\CartNotFoundException',
  'CustomerException' => '\\Red61\\Via\\Exception\\CustomerException',
  'CustomerMergedException' => '\\Red61\\Via\\Exception\\CustomerMergedException',
  'DuplicateRecordException' => '\\Red61\\Via\\Exception\\DuplicateRecordException',
  'FailedConvertException' => '\\Red61\\Via\\Exception\\FailedConvertException',
  'FailedReleaseException' => '\\Red61\\Via\\Exception\\FailedReleaseException',
  'FailedRevertException' => '\\Red61\\Via\\Exception\\FailedRevertException',
  'FinderException' => '\\Red61\\Via\\Exception\\FinderException',
  'GiftAidDeclarationOverlapException' => '\\Red61\\Via\\Exception\\GiftAidDeclarationOverlapException',
  'IllegalGiftAidException' => '\\Red61\\Via\\Exception\\IllegalGiftAidException',
  'InsuranceQuotesException' => '\\Red61\\Via\\Exception\\InsuranceQuotesException',
  'InvalidCodeException' => '\\Red61\\Via\\Exception\\InvalidCodeException',
  'InvalidHashException' => '\\Red61\\Via\\Exception\\InvalidHashException',
  'InvalidStateException' => '\\Red61\\Via\\Exception\\InvalidStateException',
  'InvalidTokenException' => '\\Red61\\Via\\Exception\\InvalidTokenException',
  'LoginDisabledException' => '\\Red61\\Via\\Exception\\LoginDisabledException',
  'MerchandiseUnavailableException' => '\\Red61\\Via\\Exception\\MerchandiseUnavailableException',
  'NoOffersException' => '\\Red61\\Via\\Exception\\NoOffersException',
  'NoResultsException' => '\\Red61\\Via\\Exception\\NoResultsException',
  'PasswordResetException' => '\\Red61\\Via\\Exception\\PasswordResetException',
  'QuestionnaireValidationException' => '\\Red61\\Via\\Exception\\QuestionnaireValidationException',
  'RecommendationException' => '\\Red61\\Via\\Exception\\RecommendationException',
  'SchemeUnavailableException' => '\\Red61\\Via\\Exception\\SchemeUnavailableException',
  'TooManyCartsException' => '\\Red61\\Via\\Exception\\TooManyCartsException',
  'UnavailablePrintOptionException' => '\\Red61\\Via\\Exception\\UnavailablePrintOptionException',
  'ViaApiOrderFailException' => '\\Red61\\Via\\Exception\\ViaApiOrderFailException',
  'VoucherTypeUnavailableException' => '\\Red61\\Via\\Exception\\VoucherTypeUnavailableException',
  'WheelchairUpdateException' => '\\Red61\\Via\\Exception\\WheelchairUpdateException',
  '_generic' => '\\Red61\\Via\\Exception\\ViaSoapFault',
);

}
