<?php
/**
 * Defines the RawViaApiDigitalPerformancePurchase data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * 
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiDigitalPerformancePurchase.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiDigitalPerformancePurchase.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiDigitalPerformancePurchase {

  /**
   * Contains per-ticket and contentURL but not per-order barcodes
   *
   * @var \Red61\Via\DataObject\ViaApiTicketDetailsWithStatus[]
   */
  protected $tickets;

  /**
   * Per order-order barcodes for this performance
   *
   * @var string[]
   */
  protected $barcodeURLs;

  /**
   * The performance title of the performance these tickets are for.
   *
   * @var string
   */
  protected $performance;

  /**
   * The performance reference of the performance these tickets are for in the form "serverId:performanceId".
   *
   * @var string
   */
  protected $performanceId;

  /**
   * The date of the performance these tickets are for in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @var string
   */
  protected $date;

  /**
   * URL where content for performance can be accessed.
   *
   * @var string
   */
  protected $contentUrl;

  /**
   * The delivery format for this performance: PHYSICAL, DIGITAL_OD, DIGITAL_LIVE or DIGITAL_CATCHUP
   *
   * @var string
   */
  protected $presentationFormat;

  /**
   * The date that digital content for this performance is available in the form "yyyy-MM-dd HH:mm:ss". Note, can be
   * NULL for performances with no digital content. See the `java.text.SimpleDateFormat` documentation for information
   * on this format.
   *
   * @var string
   */
  protected $publishDateTime;

  /**
   * URL where catchup content for performance can be accessed.
   *
   * @var string
   */
  protected $catchupUrl;

  /**
   * The tags applied to this performance.
   *
   * @var \Red61\Via\DataObject\ViaApiTagDetails[]
   */
  protected $performanceTags;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'tickets':
        return $this->getTickets();
      case 'barcodeURLs':
        return $this->getBarcodeURLs();
      case 'performance':
        return $this->getPerformance();
      case 'performanceId':
        return $this->getPerformanceId();
      case 'date':
        return $this->getDate();
      case 'contentUrl':
        return $this->getContentUrl();
      case 'presentationFormat':
        return $this->getPresentationFormat();
      case 'publishDateTime':
        return $this->getPublishDateTime();
      case 'catchupUrl':
        return $this->getCatchupUrl();
      case 'performanceTags':
        return $this->getPerformanceTags();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * Contains per-ticket and contentURL but not per-order barcodes
   *
   * @return \Red61\Via\DataObject\ViaApiTicketDetailsWithStatus[]
   */
  public function getTickets()
  {
	return $this->tickets ? : array();
  }


  /**
   * Per order-order barcodes for this performance
   *
   * @return string[]
   */
  public function getBarcodeURLs()
  {
	return $this->barcodeURLs ? : array();
  }


  /**
   * The performance title of the performance these tickets are for.
   *
   * @return string
   */
  public function getPerformance()
  {
    return $this->performance;
  }


  /**
   * The performance reference of the performance these tickets are for in the form "serverId:performanceId".
   *
   * @return string
   */
  public function getPerformanceId()
  {
    return $this->performanceId;
  }


  /**
   * The date of the performance these tickets are for in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @return string
   */
  public function getDate()
  {
    return $this->date;
  }


  /**
   * URL where content for performance can be accessed.
   *
   * @return string
   */
  public function getContentUrl()
  {
    return $this->contentUrl;
  }


  /**
   * The delivery format for this performance: PHYSICAL, DIGITAL_OD, DIGITAL_LIVE or DIGITAL_CATCHUP
   *
   * @return string
   */
  public function getPresentationFormat()
  {
    return $this->presentationFormat;
  }


  /**
   * The date that digital content for this performance is available in the form "yyyy-MM-dd HH:mm:ss". Note, can be
   * NULL for performances with no digital content. See the `java.text.SimpleDateFormat` documentation for information
   * on this format.
   *
   * @return string
   */
  public function getPublishDateTime()
  {
    return $this->publishDateTime;
  }


  /**
   * URL where catchup content for performance can be accessed.
   *
   * @return string
   */
  public function getCatchupUrl()
  {
    return $this->catchupUrl;
  }


  /**
   * The tags applied to this performance.
   *
   * @return \Red61\Via\DataObject\ViaApiTagDetails[]
   */
  public function getPerformanceTags()
  {
	return $this->performanceTags ? : array();
  }


}
