<?php
/**
 * Defines the RawapiUpdateWheelChairTicketsInBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method may be used to assign ticket(s) as wheelchair users for an unreserved performance already in the basket.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiUpdateWheelChairTicketsInBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiUpdateWheelChairTicketsInBasketRequest.
 */
abstract class RawapiUpdateWheelChairTicketsInBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiUpdateWheelChairTicketsInBasket';

  /**
   * The id of the performance these `productIds` belong to, in the form 'serverId:performanceId'.
   *
   * @var string
   */
  protected $performanceRef;

  /**
   * An int array of the product ids to change the wheelchair status for. The id's must belong to the `performanceRef`
   * to be updated.
   *
   * @var int[]
   */
  protected $productIds;

  /**
   * If `true` then the given products will be marked as W/C (wheelchair user), if `false` then WC will be removed from
   * the given products
   *
   * @var bool
   */
  protected $addWC;

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the performance these `productIds` belong to, in the form 'serverId:performanceId'.
   *
   * @return string
   */
  public function getPerformanceRef()
  {
    return $this->performanceRef;
  }


  /**
   * The id of the performance these `productIds` belong to, in the form 'serverId:performanceId'.
   *
   * @param string $performanceRef
   *
   * @return $this
   */
  public function setPerformanceRef($performanceRef)
  {
    $this->performanceRef = $performanceRef;
    return $this;
  }

  /**
   * An int array of the product ids to change the wheelchair status for. The id's must belong to the `performanceRef`
   * to be updated.
   *
   * @return int[]
   */
  public function getProductIds()
  {
    return $this->productIds;
  }


  /**
   * An int array of the product ids to change the wheelchair status for. The id's must belong to the `performanceRef`
   * to be updated.
   *
   * @param int[] $productIds
   *
   * @return $this
   */
  public function setProductIds($productIds)
  {
    $this->productIds = $productIds;
    return $this;
  }

  /**
   * If `true` then the given products will be marked as W/C (wheelchair user), if `false` then WC will be removed from
   * the given products
   *
   * @return bool
   */
  public function getAddWC()
  {
    return $this->addWC;
  }


  /**
   * If `true` then the given products will be marked as W/C (wheelchair user), if `false` then WC will be removed from
   * the given products
   *
   * @param bool $addWC
   *
   * @return $this
   */
  public function setAddWC($addWC)
  {
    $this->addWC = $addWC;
    return $this;
  }

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
