<?php
/**
 * Defines the RawapiDeclineQuestionnaireRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Called to indicate that the given customer has declined to answer this questionnaire. This customer wont be prompted
 * with this questionnaire in the future.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiDeclineQuestionnaireRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiDeclineQuestionnaireRequest.
 */
abstract class RawapiDeclineQuestionnaireRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiDeclineQuestionnaire';

  /**
   * The id of the customer declining to answer
   *
   * @var int
   */
  protected $customerId;

  /**
   * The id of the questionnaire being declined
   *
   * @var int
   */
  protected $questionnaireId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer declining to answer
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer declining to answer
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The id of the questionnaire being declined
   *
   * @return int
   */
  public function getQuestionnaireId()
  {
    return $this->questionnaireId;
  }


  /**
   * The id of the questionnaire being declined
   *
   * @param int $questionnaireId
   *
   * @return $this
   */
  public function setQuestionnaireId($questionnaireId)
  {
    $this->questionnaireId = $questionnaireId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
