<?php
/**
 * Defines the RawapiGetVoucherGiftDetailsForOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns a List of vouchers for the given transaction id, the voucher details will contain additional information on
 * the voucherCode, giftedStatus, description and initalValue of each voucher.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetVoucherGiftDetailsForOrderRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetVoucherGiftDetailsForOrderRequest.
 */
abstract class RawapiGetVoucherGiftDetailsForOrderRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetVoucherGiftDetailsForOrder';

  /**
   * Order id in format 'serverId:orderId'
   *
   * @var string
   */
  protected $orderId;

  /**
   * the title of the order
   *
   * @var string
   */
  protected $orderTitle;

  /**
   * The customer of the order
   *
   * @var int
   */
  protected $customerId;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * Order id in format 'serverId:orderId'
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * Order id in format 'serverId:orderId'
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * the title of the order
   *
   * @return string
   */
  public function getOrderTitle()
  {
    return $this->orderTitle;
  }


  /**
   * the title of the order
   *
   * @param string $orderTitle
   *
   * @return $this
   */
  public function setOrderTitle($orderTitle)
  {
    $this->orderTitle = $orderTitle;
    return $this;
  }

  /**
   * The customer of the order
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The customer of the order
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
