<?php
/**
 * Defines the RawapiSetCustomerConsentAnswersRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Save new answers to data protection consent questions, for the given customer.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSetCustomerConsentAnswersRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSetCustomerConsentAnswersRequest.
 */
abstract class RawapiSetCustomerConsentAnswersRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiSetCustomerConsentAnswers';

  /**
   * The customer who these answers are for
   *
   * @var int
   */
  protected $customerId;

  /**
   * The questions being answered, with the customer's answers
   *
   * @var \Red61\Via\DataObject\ViaApiCustomerConsentQuestion[]
   */
  protected $questions;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The customer who these answers are for
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The customer who these answers are for
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The questions being answered, with the customer's answers
   *
   * @return \Red61\Via\DataObject\ViaApiCustomerConsentQuestion[]
   */
  public function getQuestions()
  {
    return $this->questions;
  }


  /**
   * The questions being answered, with the customer's answers
   *
   * @param \Red61\Via\DataObject\ViaApiCustomerConsentQuestion[] $questions
   *
   * @return $this
   */
  public function setQuestions($questions)
  {
    $this->questions = $questions;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
