<?php
/**
 * Defines the RawapiGetCustomerTransactionsSummaryByDateRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Get transaction summary objects for the given customer, between the given dates. Orders not filtered by 'paid'
 * status.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetCustomerTransactionsSummaryByDateRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetCustomerTransactionsSummaryByDateRequest.
 */
abstract class RawapiGetCustomerTransactionsSummaryByDateRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetCustomerTransactionsSummaryByDate';

  /**
   * The customer whose transactions to search for
   *
   * @var int
   */
  protected $customerId;

  /**
   * orders created on or after this date
   *
   * @var string
   */
  protected $startDate;

  /**
   * orders created on or before this date
   *
   * @var string
   */
  protected $endDate;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The customer whose transactions to search for
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The customer whose transactions to search for
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * orders created on or after this date
   *
   * @return string
   */
  public function getStartDate()
  {
    return $this->startDate;
  }


  /**
   * orders created on or after this date
   *
   * @param string $startDate
   *
   * @return $this
   */
  public function setStartDate($startDate)
  {
    $this->startDate = $startDate;
    return $this;
  }

  /**
   * orders created on or before this date
   *
   * @return string
   */
  public function getEndDate()
  {
    return $this->endDate;
  }


  /**
   * orders created on or before this date
   *
   * @param string $endDate
   *
   * @return $this
   */
  public function setEndDate($endDate)
  {
    $this->endDate = $endDate;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
