<?php
/**
 * Defines the RawViaApiSubscriptionDetails data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores information on the customers subscription and also the scheme for the subscription.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiSubscriptionDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiSubscriptionDetails.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiSubscriptionDetails {

  /**
   * The reference of the scheme this subscription is a member of in the form "serverId:schemeId".
   *
   * @var string
   */
  protected $schemeRef;

  /**
   * The title of the scheme for this subscription.
   *
   * @var string
   */
  protected $schemeTitle;

  /**
   * The code of the scheme for this subscription.
   *
   * @var string
   */
  protected $schemeCode;

  /**
   * The start date of the scheme for this subscription in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @var string
   */
  protected $schemeStartDate;

  /**
   * The end date of the scheme for this subscription in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @var string
   */
  protected $schemeEndDate;

  /**
   * The start date of this subscription in the form "yyyy-MM-dd HH:mm:ss". See the `java.text.SimpleDateFormat`
   * documentation for information on this format.
   *
   * @var string
   */
  protected $subscriptionsStartDate;

  /**
   * The end date of this subscription in the form "yyyy-MM-dd HH:mm:ss". See the `java.text.SimpleDateFormat`
   * documentation for information on this format.
   *
   * @var string
   */
  protected $subscriptionEndDate;

  /**
   * Identifier for whether or not this subscription is for a rollign scheme.
   *
   * @var bool
   */
  protected $rollingScheme;

  /**
   * The earliest date at which it will be possible for the customer to renew their subscription in the form "yyyy-MM-dd
   * HH:mm:ss", value will be NULL for subscriptions to non-rolling schemes. See the `java.text.SimpleDateFormat`
   * documentation for information on this format.
   *
   * @var string
   */
  protected $earliestRenewalDate;

  /**
   * whether this subscription has been refunded
   *
   * @var bool
   */
  protected $refunded;

  /**
   * The forename of the customer that has claimed / been gifted this subscription using a token.
   *
   * @var string
   */
  protected $customerForename;

  /**
   * The surname of the customer that has claimed / been gifted this subscription using a token.
   *
   * @var string
   */
  protected $customerSurname;

  /**
   * The reference for the scheme tier of this subscription in the form "serverId:schemeId:tierId".
   *
   * @var string
   */
  protected $tierRef;

  /**
   * The reference for the tier in the form "serverId:tierId".
   *
   * @var string
   */
  protected $translationTierId;

  /**
   * The title of the scheme tier for this subscription.
   *
   * @var string
   */
  protected $tierTitle;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'schemeRef':
        return $this->getSchemeRef();
      case 'schemeTitle':
        return $this->getSchemeTitle();
      case 'schemeCode':
        return $this->getSchemeCode();
      case 'schemeStartDate':
        return $this->getSchemeStartDate();
      case 'schemeEndDate':
        return $this->getSchemeEndDate();
      case 'subscriptionsStartDate':
        return $this->getSubscriptionsStartDate();
      case 'subscriptionEndDate':
        return $this->getSubscriptionEndDate();
      case 'rollingScheme':
        return $this->getRollingScheme();
      case 'earliestRenewalDate':
        return $this->getEarliestRenewalDate();
      case 'refunded':
        return $this->getRefunded();
      case 'customerForename':
        return $this->getCustomerForename();
      case 'customerSurname':
        return $this->getCustomerSurname();
      case 'tierRef':
        return $this->getTierRef();
      case 'translationTierId':
        return $this->getTranslationTierId();
      case 'tierTitle':
        return $this->getTierTitle();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of the scheme this subscription is a member of in the form "serverId:schemeId".
   *
   * @return string
   */
  public function getSchemeRef()
  {
    return $this->schemeRef;
  }


  /**
   * The title of the scheme for this subscription.
   *
   * @return string
   */
  public function getSchemeTitle()
  {
    return $this->schemeTitle;
  }


  /**
   * The code of the scheme for this subscription.
   *
   * @return string
   */
  public function getSchemeCode()
  {
    return $this->schemeCode;
  }


  /**
   * The start date of the scheme for this subscription in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @return string
   */
  public function getSchemeStartDate()
  {
    return $this->schemeStartDate;
  }


  /**
   * The end date of the scheme for this subscription in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @return string
   */
  public function getSchemeEndDate()
  {
    return $this->schemeEndDate;
  }


  /**
   * The start date of this subscription in the form "yyyy-MM-dd HH:mm:ss". See the `java.text.SimpleDateFormat`
   * documentation for information on this format.
   *
   * @return string
   */
  public function getSubscriptionsStartDate()
  {
    return $this->subscriptionsStartDate;
  }


  /**
   * The end date of this subscription in the form "yyyy-MM-dd HH:mm:ss". See the `java.text.SimpleDateFormat`
   * documentation for information on this format.
   *
   * @return string
   */
  public function getSubscriptionEndDate()
  {
    return $this->subscriptionEndDate;
  }


  /**
   * Identifier for whether or not this subscription is for a rollign scheme.
   *
   * @return bool
   */
  public function getRollingScheme()
  {
    return $this->rollingScheme;
  }


  /**
   * The earliest date at which it will be possible for the customer to renew their subscription in the form "yyyy-MM-dd
   * HH:mm:ss", value will be NULL for subscriptions to non-rolling schemes. See the `java.text.SimpleDateFormat`
   * documentation for information on this format.
   *
   * @return string
   */
  public function getEarliestRenewalDate()
  {
    return $this->earliestRenewalDate;
  }


  /**
   * whether this subscription has been refunded
   *
   * @return bool
   */
  public function getRefunded()
  {
    return $this->refunded;
  }


  /**
   * The forename of the customer that has claimed / been gifted this subscription using a token.
   *
   * @return string
   */
  public function getCustomerForename()
  {
    return $this->customerForename;
  }


  /**
   * The surname of the customer that has claimed / been gifted this subscription using a token.
   *
   * @return string
   */
  public function getCustomerSurname()
  {
    return $this->customerSurname;
  }


  /**
   * The reference for the scheme tier of this subscription in the form "serverId:schemeId:tierId".
   *
   * @return string
   */
  public function getTierRef()
  {
    return $this->tierRef;
  }


  /**
   * The reference for the tier in the form "serverId:tierId".
   *
   * @return string
   */
  public function getTranslationTierId()
  {
    return $this->translationTierId;
  }


  /**
   * The title of the scheme tier for this subscription.
   *
   * @return string
   */
  public function getTierTitle()
  {
    return $this->tierTitle;
  }


}
