<?php
/**
 * Defines the RawViaApiCardPaymentRequest data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Card payment object extending `ViaApiOrderDetails` containing additional payment form html used to take payment from
 * the customer.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiCardPaymentRequest.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiCardPaymentRequest.
 */
abstract class RawViaApiCardPaymentRequest {

  /**
   * in the form 'LOCAL_SERVER_ID:entityId' where entityId is 'orderId' for methods:
   * 
   * - `apiCreateOrder`
   * - `apiCompleteOrder`
   * 
   * entityId is the 'paymentId' for the method:
   * 
   * - `apiCreateInitialUnpaidOrder`. Red61 recommend using the '`sessionId|paymentId`' see `apiGetBasketSessionId` for
   * the payment tracking value.
   * 
   * If the entityId is less than 0 then an error has occurred during these critical order creation methods. If the
   * entityId is:
   * 
   * - `-100 <= entityId <= -1` then server Error see `OrderCode#SERVER_ERROR`
   * - `-200 <= entityId <= -101` then payment Error see `OrderCode#PAYMENT_ERROR`
   * - `-300 <= entityId <= -201` then payment Setup Error see `OrderCode#PAYMENT_SETUP_NOT_ONLINE_ERROR` only if using
   * independent Payment Processor
   * 
   * If code = '-302' then this means redirect to url defined in statusmessage. This is only returned if additional 3D
   * secure authorisation is required, see `apiCreateOrder` for details.
   *
   * @var string
   */
  protected $code;

  /**
   * A message describing the result of the method call.
   *
   * @var string
   */
  protected $statusmessage;

  /**
   * HTML containing the payment form to be displayed to the customer. Allowing payment details to be taken
   *
   * @var string
   */
  protected $paymentFormHTML;

  /**
   * The name of the payment provider being used, can be used with providerData to build the front-end rather than using
   * the supplied paymentFormHTML
   *
   * @var string
   */
  protected $provider;

  /**
   * The parameters needed by the front-end if not using paymentFormHTML as JSON
   *
   * @var string
   */
  protected $providerData;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'code':
        return $this->getCode();
      case 'statusmessage':
        return $this->getStatusmessage();
      case 'paymentFormHTML':
        return $this->getPaymentFormHTML();
      case 'provider':
        return $this->getProvider();
      case 'providerData':
        return $this->getProviderData();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * in the form 'LOCAL_SERVER_ID:entityId' where entityId is 'orderId' for methods:
   * 
   * - `apiCreateOrder`
   * - `apiCompleteOrder`
   * 
   * entityId is the 'paymentId' for the method:
   * 
   * - `apiCreateInitialUnpaidOrder`. Red61 recommend using the '`sessionId|paymentId`' see `apiGetBasketSessionId` for
   * the payment tracking value.
   * 
   * If the entityId is less than 0 then an error has occurred during these critical order creation methods. If the
   * entityId is:
   * 
   * - `-100 <= entityId <= -1` then server Error see `OrderCode#SERVER_ERROR`
   * - `-200 <= entityId <= -101` then payment Error see `OrderCode#PAYMENT_ERROR`
   * - `-300 <= entityId <= -201` then payment Setup Error see `OrderCode#PAYMENT_SETUP_NOT_ONLINE_ERROR` only if using
   * independent Payment Processor
   * 
   * If code = '-302' then this means redirect to url defined in statusmessage. This is only returned if additional 3D
   * secure authorisation is required, see `apiCreateOrder` for details.
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


  /**
   * A message describing the result of the method call.
   *
   * @return string
   */
  public function getStatusmessage()
  {
    return $this->statusmessage;
  }


  /**
   * HTML containing the payment form to be displayed to the customer. Allowing payment details to be taken
   *
   * @return string
   */
  public function getPaymentFormHTML()
  {
    return $this->paymentFormHTML;
  }


  /**
   * The name of the payment provider being used, can be used with providerData to build the front-end rather than using
   * the supplied paymentFormHTML
   *
   * @return string
   */
  public function getProvider()
  {
    return $this->provider;
  }


  /**
   * The parameters needed by the front-end if not using paymentFormHTML as JSON
   *
   * @return string
   */
  public function getProviderData()
  {
    return $this->providerData;
  }


}
