<?php
/**
 * Defines ViaApiCallNotificationSpec - specifications for Red61\Via\Plugin\ViaApiCallNotification
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\Plugin;

use PhpSpec\Exception\Example\FailureException;
use Red61\Via\ApiRequest\apiGetVersionRequest;
use Red61\Via\Plugin\ViaApiCallNotification;
use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\Plugin\ViaApiCallNotification
 */
class ViaApiCallNotificationSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\Plugin\ViaApiCallNotification
     */
	protected $subject;

	function let()
	{
		$this->beConstructedWith(new apiGetVersionRequest);
	}

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\Plugin\ViaApiCallNotification');
	}

	function it_returns_call_status_as_the_notification_name()
	{
		$this->subject->getNotificationName()->shouldBe($this->subject->getCallStatus());
	}

	function it_is_on_before_call_by_default()
	{
		$this->subject->getCallStatus()->shouldBe(ViaApiCallNotification::ON_BEFORE_CALL);
	}

	function it_is_on_success_when_response_is_set()
	{
		$this->subject->_setSuccessfulResponse(TRUE);
		$this->subject->getCallStatus()->shouldBe(ViaApiCallNotification::ON_CALL_SUCCESS);
	}

	function it_is_on_failure_when_exception_is_set()
	{
		$this->subject->_setFailureException(new \Exception('Foo'));
		$this->subject->getCallStatus()->shouldBe(ViaApiCallNotification::ON_CALL_FAILED);
	}

	function it_should_not_skip_by_default()
	{
		expect($this->subject->getWrappedObject()->shouldSkipCall())->toBe(FALSE);
	}

	function it_should_skip_when_any_response_is_provided()
	{
		$this->subject->skipCallAndReturn(NULL);
		expect($this->subject->getWrappedObject()->shouldSkipCall())->toBe(TRUE);
	}

	function it_should_provide_call_start_time()
	{
		$before = microtime(TRUE);
		$time = $this->subject->getStartMicrotime()->getWrappedObject();
		$after = microtime(TRUE);

		if ($time < $before) {
			throw new FailureException("Start microtime of ".$time." was before start of spec");
		}
		if ($time > $after) {
			throw new FailureException("Start microtime of ".$time." was after end of spec");
		}
	}

}
