<?php
/**
 * Defines the RawViaApiDonationType data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * 
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiDonationType.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiDonationType.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiDonationType {

  /**
   * The reference of this donation type in the form "serverId:donationTypeId".
   *
   * @var string
   */
  protected $donationTypeRef;

  /**
   * The reference of this donation fund in the form "serverId:donationFundId".
   *
   * @var string
   */
  protected $donationFundRef;

  /**
   * The type option of the Donation Type. i.e. (One off, Recurring, Pledge)
   *
   * @var string
   */
  protected $typeOption;

  /**
   * The box office defined code of this donation type. This may be null, but if defined will be unique within a given
   * Red61 ticketing system
   *
   * @var string
   */
  protected $code;

  /**
   * The title for the Donation Type.
   *
   * @var string
   */
  protected $title;

  /**
   * The subtitle for the Donation Type.
   *
   * @var string
   */
  protected $subtitle;

  /**
   * The description for this Donation Type.
   *
   * @var string
   */
  protected $description;

  /**
   * The suggested value for which customers should make donations for this fund type.
   *
   * @var double
   */
  protected $suggestedValue;

  /**
   * The suggested number of payments to be made. (Only applicable to type option "Pledge")
   *
   * @var int
   */
  protected $suggestedNoOfPayments;

  /**
   * The suggested frequency of payment intervals that payment will be taken i.e a value of 2 combined with an interval
   * value of "WEEKLY" would result in payment being taken every 2 weeks (Not applicable to type option "One off").
   *
   * @var int
   */
  protected $suggestedPaymentPeriod;

  /**
   * The suggested interval at which payment will be taken (e.g. WEEKLY, MONTHLY, QUARTERLY, ANNUALLY)
   *
   * @var string
   */
  protected $suggestedPaymentInterval;

  /**
   * Flag indicating that this donation type allows for payment to be handled by a box office operator if desired. (Only
   * applicable to type option "Pledge")
   *
   * @var bool
   */
  protected $manualPaymentAvailable;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'donationTypeRef':
        return $this->getDonationTypeRef();
      case 'donationFundRef':
        return $this->getDonationFundRef();
      case 'typeOption':
        return $this->getTypeOption();
      case 'code':
        return $this->getCode();
      case 'title':
        return $this->getTitle();
      case 'subtitle':
        return $this->getSubtitle();
      case 'description':
        return $this->getDescription();
      case 'suggestedValue':
        return $this->getSuggestedValue();
      case 'suggestedNoOfPayments':
        return $this->getSuggestedNoOfPayments();
      case 'suggestedPaymentPeriod':
        return $this->getSuggestedPaymentPeriod();
      case 'suggestedPaymentInterval':
        return $this->getSuggestedPaymentInterval();
      case 'manualPaymentAvailable':
        return $this->getManualPaymentAvailable();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of this donation type in the form "serverId:donationTypeId".
   *
   * @return string
   */
  public function getDonationTypeRef()
  {
    return $this->donationTypeRef;
  }


  /**
   * The reference of this donation fund in the form "serverId:donationFundId".
   *
   * @return string
   */
  public function getDonationFundRef()
  {
    return $this->donationFundRef;
  }


  /**
   * The type option of the Donation Type. i.e. (One off, Recurring, Pledge)
   *
   * @return string
   */
  public function getTypeOption()
  {
    return $this->typeOption;
  }


  /**
   * The box office defined code of this donation type. This may be null, but if defined will be unique within a given
   * Red61 ticketing system
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


  /**
   * The title for the Donation Type.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The subtitle for the Donation Type.
   *
   * @return string
   */
  public function getSubtitle()
  {
    return $this->subtitle;
  }


  /**
   * The description for this Donation Type.
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * The suggested value for which customers should make donations for this fund type.
   *
   * @return double
   */
  public function getSuggestedValue()
  {
    return $this->suggestedValue;
  }


  /**
   * The suggested number of payments to be made. (Only applicable to type option "Pledge")
   *
   * @return int
   */
  public function getSuggestedNoOfPayments()
  {
    return $this->suggestedNoOfPayments;
  }


  /**
   * The suggested frequency of payment intervals that payment will be taken i.e a value of 2 combined with an interval
   * value of "WEEKLY" would result in payment being taken every 2 weeks (Not applicable to type option "One off").
   *
   * @return int
   */
  public function getSuggestedPaymentPeriod()
  {
    return $this->suggestedPaymentPeriod;
  }


  /**
   * The suggested interval at which payment will be taken (e.g. WEEKLY, MONTHLY, QUARTERLY, ANNUALLY)
   *
   * @return string
   */
  public function getSuggestedPaymentInterval()
  {
    return $this->suggestedPaymentInterval;
  }


  /**
   * Flag indicating that this donation type allows for payment to be handled by a box office operator if desired. (Only
   * applicable to type option "Pledge")
   *
   * @return bool
   */
  public function getManualPaymentAvailable()
  {
    return $this->manualPaymentAvailable;
  }


}
