<?php
/**
 * Defines the RawapiApplyInsuranceToBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method applies the selected insurance quote against the current basket.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiApplyInsuranceToBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiApplyInsuranceToBasketRequest.
 */
abstract class RawapiApplyInsuranceToBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiApplyInsuranceToBasket';

  /**
   * The `ViaApiInsuranceQuoteDetails#quoteReference` of the quote to be applied to the basket
   *
   * @var string
   */
  protected $insuranceQuoteRef;

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The `ViaApiInsuranceQuoteDetails#quoteReference` of the quote to be applied to the basket
   *
   * @return string
   */
  public function getInsuranceQuoteRef()
  {
    return $this->insuranceQuoteRef;
  }


  /**
   * The `ViaApiInsuranceQuoteDetails#quoteReference` of the quote to be applied to the basket
   *
   * @param string $insuranceQuoteRef
   *
   * @return $this
   */
  public function setInsuranceQuoteRef($insuranceQuoteRef)
  {
    $this->insuranceQuoteRef = $insuranceQuoteRef;
    return $this;
  }

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
