<?php
/**
 * Defines the RawapiGetPerformanceDatesRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Lists unique performance dates for the supplied event. Designed to be used to build a calendar of performances - when
 * the user selects a date then use `apiGetPerformancesByDate` to fetch the performances on that date. Digital
 * performances which have no date and time are returned grouped in the first element with a `null`
 * `ViaApiPerformanceDate#date`. Digital performances will also have an empty `ViaApiPerformanceDate#times` collection.
 * This method will attempt translation of it's returned objects, where available.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetPerformanceDatesRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetPerformanceDatesRequest.
 */
abstract class RawapiGetPerformanceDatesRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetPerformanceDates';

  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @var string
   */
  protected $eventRef;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @return string
   */
  public function getEventRef()
  {
    return $this->eventRef;
  }


  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @param string $eventRef
   *
   * @return $this
   */
  public function setEventRef($eventRef)
  {
    $this->eventRef = $eventRef;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
