<?php
/**
 * Defines the RawapiRefundCompItemsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Refunds the selected complimentary items (i.e. free tickets) from the given order.
 * 
 * Can not be used to refund anything that cost money.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiRefundCompItemsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiRefundCompItemsRequest.
 */
abstract class RawapiRefundCompItemsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiRefundCompItems';

  /**
   * Original order to refund items from, in format 'serverId:orderId'
   *
   * @var string
   */
  protected $orderId;

  /**
   * Items to refund
   *
   * @var int[]
   */
  protected $itemIds;

  /**
   * Reasons for the refund
   *
   * @var string
   */
  protected $refundNote;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * Original order to refund items from, in format 'serverId:orderId'
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * Original order to refund items from, in format 'serverId:orderId'
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * Items to refund
   *
   * @return int[]
   */
  public function getItemIds()
  {
    return $this->itemIds;
  }


  /**
   * Items to refund
   *
   * @param int[] $itemIds
   *
   * @return $this
   */
  public function setItemIds($itemIds)
  {
    $this->itemIds = $itemIds;
    return $this;
  }

  /**
   * Reasons for the refund
   *
   * @return string
   */
  public function getRefundNote()
  {
    return $this->refundNote;
  }


  /**
   * Reasons for the refund
   *
   * @param string $refundNote
   *
   * @return $this
   */
  public function setRefundNote($refundNote)
  {
    $this->refundNote = $refundNote;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
