<?php
/**
 * Defines the RawapiAddTicketsToBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Adds the supplied tickets to the basket identified by `sessionId`.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiAddTicketsToBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiAddTicketsToBasketRequest.
 */
abstract class RawapiAddTicketsToBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiAddTicketsToBasket';

  /**
   * ID of the server/performance to add tickets from.
   *
   * @var string
   */
  protected $performanceRef;

  /**
   * An array of `ViaApiTicketRequest` objects containing details about the requested tickets
   *
   * @var \Red61\Via\DataObject\ViaApiTicketRequest[]
   */
  protected $ticketsList;

  /**
   * The id of the baskets customer if known (@deprecated)
   *
   * @var int
   */
  protected $customerId;

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * ID of the server/performance to add tickets from.
   *
   * @return string
   */
  public function getPerformanceRef()
  {
    return $this->performanceRef;
  }


  /**
   * ID of the server/performance to add tickets from.
   *
   * @param string $performanceRef
   *
   * @return $this
   */
  public function setPerformanceRef($performanceRef)
  {
    $this->performanceRef = $performanceRef;
    return $this;
  }

  /**
   * An array of `ViaApiTicketRequest` objects containing details about the requested tickets
   *
   * @return \Red61\Via\DataObject\ViaApiTicketRequest[]
   */
  public function getTicketsList()
  {
    return $this->ticketsList;
  }


  /**
   * An array of `ViaApiTicketRequest` objects containing details about the requested tickets
   *
   * @param \Red61\Via\DataObject\ViaApiTicketRequest[] $ticketsList
   *
   * @return $this
   */
  public function setTicketsList($ticketsList)
  {
    $this->ticketsList = $ticketsList;
    return $this;
  }

  /**
   * The id of the baskets customer if known (@deprecated)
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the baskets customer if known (@deprecated)
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
