<?php
/**
 * Defines the RawapiGetOfferPerformancesRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Fetches basic information for performances that use a given ticket offer (by concession code), between start and end
 * date/time parameters
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetOfferPerformancesRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetOfferPerformancesRequest.
 */
abstract class RawapiGetOfferPerformancesRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetOfferPerformances';

  /**
   * concession code of the offer to filter by
   *
   * @var string
   */
  protected $concessionCode;

  /**
   * Starting datetime of the search window
   *
   * @var string
   */
  protected $startTime;

  /**
   * Ending datetime of the search window
   *
   * @var string
   */
  protected $endTime;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * concession code of the offer to filter by
   *
   * @return string
   */
  public function getConcessionCode()
  {
    return $this->concessionCode;
  }


  /**
   * concession code of the offer to filter by
   *
   * @param string $concessionCode
   *
   * @return $this
   */
  public function setConcessionCode($concessionCode)
  {
    $this->concessionCode = $concessionCode;
    return $this;
  }

  /**
   * Starting datetime of the search window
   *
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }


  /**
   * Starting datetime of the search window
   *
   * @param string $startTime
   *
   * @return $this
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
    return $this;
  }

  /**
   * Ending datetime of the search window
   *
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }


  /**
   * Ending datetime of the search window
   *
   * @param string $endTime
   *
   * @return $this
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
