<?php
/**
 * Defines the RawapiFilterEventsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Searches for events based on the supplied parameters.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiFilterEventsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiFilterEventsRequest.
 */
abstract class RawapiFilterEventsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiFilterEvents';

  /**
   * The id of the venue.
   *
   * @var string
   */
  protected $venueRef;

  /**
   * The id of the subvenue.
   *
   * @var string
   */
  protected $subVenueRef;

  /**
   * The id of the event type.
   *
   * @var int
   */
  protected $typeId;

  /**
   * The id of the event sub-type.
   *
   * @var int
   */
  protected $subTypeId;

  /**
   * The id of the artist/company.
   *
   * @var string
   */
  protected $companyRef;

  /**
   * either LEGACY: the time period, current allowed values are "today", "tomorrow", "thisweek", "nextweek", "thismonth"
   * and "nextmonth". See /includes/filter.php OR the date and start time of a performance for an event
   *
   * @var string
   */
  protected $startDateTime;

  /**
   * date and start time of a performance of an event. In combination with *$start* creates a datetime window for the
   * start datetimes of event performances.
   *
   * @var string
   */
  protected $endDateTime;

  /**
   * The season code
   *
   * @var string
   */
  protected $seasonCode;

  /**
   * A list of age suitability codes
   *
   * @var string[]
   */
  protected $ageSuitabilityCodes;

  /**
   * authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the venue.
   *
   * @return string
   */
  public function getVenueRef()
  {
    return $this->venueRef;
  }


  /**
   * The id of the venue.
   *
   * @param string $venueRef
   *
   * @return $this
   */
  public function setVenueRef($venueRef)
  {
    $this->venueRef = $venueRef;
    return $this;
  }

  /**
   * The id of the subvenue.
   *
   * @return string
   */
  public function getSubVenueRef()
  {
    return $this->subVenueRef;
  }


  /**
   * The id of the subvenue.
   *
   * @param string $subVenueRef
   *
   * @return $this
   */
  public function setSubVenueRef($subVenueRef)
  {
    $this->subVenueRef = $subVenueRef;
    return $this;
  }

  /**
   * The id of the event type.
   *
   * @return int
   */
  public function getTypeId()
  {
    return $this->typeId;
  }


  /**
   * The id of the event type.
   *
   * @param int $typeId
   *
   * @return $this
   */
  public function setTypeId($typeId)
  {
    $this->typeId = $typeId;
    return $this;
  }

  /**
   * The id of the event sub-type.
   *
   * @return int
   */
  public function getSubTypeId()
  {
    return $this->subTypeId;
  }


  /**
   * The id of the event sub-type.
   *
   * @param int $subTypeId
   *
   * @return $this
   */
  public function setSubTypeId($subTypeId)
  {
    $this->subTypeId = $subTypeId;
    return $this;
  }

  /**
   * The id of the artist/company.
   *
   * @return string
   */
  public function getCompanyRef()
  {
    return $this->companyRef;
  }


  /**
   * The id of the artist/company.
   *
   * @param string $companyRef
   *
   * @return $this
   */
  public function setCompanyRef($companyRef)
  {
    $this->companyRef = $companyRef;
    return $this;
  }

  /**
   * either LEGACY: the time period, current allowed values are "today", "tomorrow", "thisweek", "nextweek", "thismonth"
   * and "nextmonth". See /includes/filter.php OR the date and start time of a performance for an event
   *
   * @return string
   */
  public function getStartDateTime()
  {
    return $this->startDateTime;
  }


  /**
   * either LEGACY: the time period, current allowed values are "today", "tomorrow", "thisweek", "nextweek", "thismonth"
   * and "nextmonth". See /includes/filter.php OR the date and start time of a performance for an event
   *
   * @param string $startDateTime
   *
   * @return $this
   */
  public function setStartDateTime($startDateTime)
  {
    $this->startDateTime = $startDateTime;
    return $this;
  }

  /**
   * date and start time of a performance of an event. In combination with *$start* creates a datetime window for the
   * start datetimes of event performances.
   *
   * @return string
   */
  public function getEndDateTime()
  {
    return $this->endDateTime;
  }


  /**
   * date and start time of a performance of an event. In combination with *$start* creates a datetime window for the
   * start datetimes of event performances.
   *
   * @param string $endDateTime
   *
   * @return $this
   */
  public function setEndDateTime($endDateTime)
  {
    $this->endDateTime = $endDateTime;
    return $this;
  }

  /**
   * The season code
   *
   * @return string
   */
  public function getSeasonCode()
  {
    return $this->seasonCode;
  }


  /**
   * The season code
   *
   * @param string $seasonCode
   *
   * @return $this
   */
  public function setSeasonCode($seasonCode)
  {
    $this->seasonCode = $seasonCode;
    return $this;
  }

  /**
   * A list of age suitability codes
   *
   * @return string[]
   */
  public function getAgeSuitabilityCodes()
  {
    return $this->ageSuitabilityCodes;
  }


  /**
   * A list of age suitability codes
   *
   * @param string[] $ageSuitabilityCodes
   *
   * @return $this
   */
  public function setAgeSuitabilityCodes($ageSuitabilityCodes)
  {
    $this->ageSuitabilityCodes = $ageSuitabilityCodes;
    return $this;
  }

  /**
   * authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
