<?php
/**
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Edinburgh International Book Festival Ltd
 * @licence   http://opensource.org/licenses/BSD-3-Clause
 */

namespace Red61\Via\Exception;

/**
 * Thrown for all VIA calls attempted while the VIA circuit breaker is tripped
 *
 * [!!] This exception extends \SoapFault for legacy compatibility reasons, but is likely
 *      in future to change to extend \BadMethodCallException or a similar runtime exception
 *      class.
 *
 * @see \Red61\Via\CircuitBreaker\ViaCircuitBreakerPlugin::onViaPluginNotification
 */
class ViaCircuitBreakerTrippedException extends \SoapFault implements ViaException {

	public function __construct()
	{
		parent::__construct(
			'CircuitBreaker',
			'The box office server is currently unavailable. Please try again later'
		);
	}
} 
