<?php
/**
 * Defines the RawapiUpdateCustomerPasswordRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Finds the customer for the given token, then updates their password to the one supplied.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiUpdateCustomerPasswordRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiUpdateCustomerPasswordRequest.
 */
abstract class RawapiUpdateCustomerPasswordRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiUpdateCustomerPassword';

  /**
   * - generated password reset token
   *
   * @var string
   */
  protected $token;

  /**
   * - customers new password
   *
   * @var string
   */
  protected $password;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * - generated password reset token
   *
   * @return string
   */
  public function getToken()
  {
    return $this->token;
  }


  /**
   * - generated password reset token
   *
   * @param string $token
   *
   * @return $this
   */
  public function setToken($token)
  {
    $this->token = $token;
    return $this;
  }

  /**
   * - customers new password
   *
   * @return string
   */
  public function getPassword()
  {
    return $this->password;
  }


  /**
   * - customers new password
   *
   * @param string $password
   *
   * @return $this
   */
  public function setPassword($password)
  {
    $this->password = $password;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
