<?php
/**
 * Defines the RawapiListSentByFriendRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to list the transaction items that can be claimed using the token generated using
 * `apiSendToAFriend` for the transaction provided. To claim the items for a customer call `apiClaimFromFriend` This
 * method will attempt translation of it's returned objects, where available.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiListSentByFriendRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiListSentByFriendRequest.
 */
abstract class RawapiListSentByFriendRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiListSentByFriend';

  /**
   * the token that would be used to claim the items
   *
   * @var string
   */
  protected $token;

  /**
   * The ID of the transaction that the items to claim are from
   *
   * @var string
   */
  protected $orderId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the token that would be used to claim the items
   *
   * @return string
   */
  public function getToken()
  {
    return $this->token;
  }


  /**
   * the token that would be used to claim the items
   *
   * @param string $token
   *
   * @return $this
   */
  public function setToken($token)
  {
    $this->token = $token;
    return $this;
  }

  /**
   * The ID of the transaction that the items to claim are from
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * The ID of the transaction that the items to claim are from
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
