<?php
/**
 * Defines the RawapiGetQuestionnaireResponseByQuestionnaireAndCustomerRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Method returns a questionnaire response with the provided questionnaire and customer IDs.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetQuestionnaireResponseByQuestionnaireAndCustomerRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetQuestionnaireResponseByQuestionnaireAndCustomerRequest.
 */
abstract class RawapiGetQuestionnaireResponseByQuestionnaireAndCustomerRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetQuestionnaireResponseByQuestionnaireAndCustomer';

  /**
   * - the Id of the desired questionnaire
   *
   * @var int
   */
  protected $questionnaireId;

  /**
   * - the customer ID for the response you want to retrieve
   *
   * @var int
   */
  protected $customerId;

  /**
   * - the authentication code to use
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * - the Id of the desired questionnaire
   *
   * @return int
   */
  public function getQuestionnaireId()
  {
    return $this->questionnaireId;
  }


  /**
   * - the Id of the desired questionnaire
   *
   * @param int $questionnaireId
   *
   * @return $this
   */
  public function setQuestionnaireId($questionnaireId)
  {
    $this->questionnaireId = $questionnaireId;
    return $this;
  }

  /**
   * - the customer ID for the response you want to retrieve
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * - the customer ID for the response you want to retrieve
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * - the authentication code to use
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * - the authentication code to use
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
