<?php
/**
 * Defines the RawapiGetCardTypeFromBINRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to retrieve the Card Type of a given card using its BIN
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetCardTypeFromBINRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetCardTypeFromBINRequest.
 */
abstract class RawapiGetCardTypeFromBINRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetCardTypeFromBIN';

  /**
   * The first 6 digits of the card
   *
   * @var string
   */
  protected $cardBIN;

  /**
   * The authentication code to use
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The first 6 digits of the card
   *
   * @return string
   */
  public function getCardBIN()
  {
    return $this->cardBIN;
  }


  /**
   * The first 6 digits of the card
   *
   * @param string $cardBIN
   *
   * @return $this
   */
  public function setCardBIN($cardBIN)
  {
    $this->cardBIN = $cardBIN;
    return $this;
  }

  /**
   * The authentication code to use
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
