<?php
/**
 * Defines the RawapiGetAccreditationByCustomerAndTypeRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Method returns the accreditation that corresponds to the supplied customer and accreditation type ID. This method
 * will attempt translation of it's returned objects, where available.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetAccreditationByCustomerAndTypeRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetAccreditationByCustomerAndTypeRequest.
 */
abstract class RawapiGetAccreditationByCustomerAndTypeRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetAccreditationByCustomerAndType';

  /**
   * - the ID of the customer for whom you want to retrieve an accreditation
   *
   * @var int
   */
  protected $customerId;

  /**
   * - - the ID of the accreditation type for which you wish to retrieve an accreditation
   *
   * @var int
   */
  protected $accreditationTypeId;

  /**
   * - The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * - the ID of the customer for whom you want to retrieve an accreditation
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * - the ID of the customer for whom you want to retrieve an accreditation
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * - - the ID of the accreditation type for which you wish to retrieve an accreditation
   *
   * @return int
   */
  public function getAccreditationTypeId()
  {
    return $this->accreditationTypeId;
  }


  /**
   * - - the ID of the accreditation type for which you wish to retrieve an accreditation
   *
   * @param int $accreditationTypeId
   *
   * @return $this
   */
  public function setAccreditationTypeId($accreditationTypeId)
  {
    $this->accreditationTypeId = $accreditationTypeId;
    return $this;
  }

  /**
   * - The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * - The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
