<?php
/**
 * Defines the RawapiCustomerEmailVerifiedActiveRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Check if the customer record exists for the given email password combination, is active and is web login enabled.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCustomerEmailVerifiedActiveRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCustomerEmailVerifiedActiveRequest.
 */
abstract class RawapiCustomerEmailVerifiedActiveRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiCustomerEmailVerifiedActive';

  /**
   * - The customer email address
   *
   * @var string
   */
  protected $email;

  /**
   * - The customer password
   *
   * @var string
   */
  protected $password;

  /**
   * - The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * - The customer email address
   *
   * @return string
   */
  public function getEmail()
  {
    return $this->email;
  }


  /**
   * - The customer email address
   *
   * @param string $email
   *
   * @return $this
   */
  public function setEmail($email)
  {
    $this->email = $email;
    return $this;
  }

  /**
   * - The customer password
   *
   * @return string
   */
  public function getPassword()
  {
    return $this->password;
  }


  /**
   * - The customer password
   *
   * @param string $password
   *
   * @return $this
   */
  public function setPassword($password)
  {
    $this->password = $password;
    return $this;
  }

  /**
   * - The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * - The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
