<?php
/**
 * Defines the RawapiCreateDonationScheduleRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method contacts the payment provider and creates the customers agreed payment schedule for the supplied donation
 * type. The returned `ViaApiCardPaymentRequest#paymentFormHTML` should be displayed to the customer if provided as it
 * allows for initial payment to be captured if required.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCreateDonationScheduleRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCreateDonationScheduleRequest.
 */
abstract class RawapiCreateDonationScheduleRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiCreateDonationSchedule';

  /**
   * ID representing the customer making this payment
   *
   * @var int
   */
  protected $customerId;

  /**
   * ID representing the donation type in the form serverId:donationTypeId
   *
   * @var string
   */
  protected $donationTypeRef;

  /**
   * Total value that the customer wishes to pledge to the donation fund (Not required for "Recurring" donation types)
   *
   * @var double
   */
  protected $pledgeValue;

  /**
   * increment value that the customer wishes to give on a recurring basis (Not required for "Pledge" donation types)
   *
   * @var double
   */
  protected $recurringValue;

  /**
   * Number of payments that the customer wishes to split their pledge into. (Not required for "Recurring" donation
   * types)
   *
   * @var int
   */
  protected $noOfPledgePayments;

  /**
   * Frequency at which the paymentInterval should trigger the donation payment. (e.g. A paymentPeriod of 2 combined
   * with a "WEEKLY" paymentInterval will result in payment being taken every 2 weeks)
   *
   * @var int
   */
  protected $paymentPeriod;

  /**
   * Frequency at which the customer wishes their regular donation to be performed. Allowed values : "WEEKLY",
   * "MONTHLY", "QUATERLY", "ANNUALLY"
   *
   * @var string
   */
  protected $paymentInterval;

  /**
   * Flag indicating that the customer wishes their payments to be processed manually (Only supported for "Pledge"
   * donation types)
   *
   * @var bool
   */
  protected $manualPayments;

  /**
   * Client defined option describing how manual payment will be taken
   *
   * @var string
   */
  protected $manualPaymentOptionMessage;

  /**
   * Client defined notes for the schedule.
   *
   * @var string
   */
  protected $notes;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * ID representing the customer making this payment
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * ID representing the customer making this payment
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * ID representing the donation type in the form serverId:donationTypeId
   *
   * @return string
   */
  public function getDonationTypeRef()
  {
    return $this->donationTypeRef;
  }


  /**
   * ID representing the donation type in the form serverId:donationTypeId
   *
   * @param string $donationTypeRef
   *
   * @return $this
   */
  public function setDonationTypeRef($donationTypeRef)
  {
    $this->donationTypeRef = $donationTypeRef;
    return $this;
  }

  /**
   * Total value that the customer wishes to pledge to the donation fund (Not required for "Recurring" donation types)
   *
   * @return double
   */
  public function getPledgeValue()
  {
    return $this->pledgeValue;
  }


  /**
   * Total value that the customer wishes to pledge to the donation fund (Not required for "Recurring" donation types)
   *
   * @param double $pledgeValue
   *
   * @return $this
   */
  public function setPledgeValue($pledgeValue)
  {
    $this->pledgeValue = $pledgeValue;
    return $this;
  }

  /**
   * increment value that the customer wishes to give on a recurring basis (Not required for "Pledge" donation types)
   *
   * @return double
   */
  public function getRecurringValue()
  {
    return $this->recurringValue;
  }


  /**
   * increment value that the customer wishes to give on a recurring basis (Not required for "Pledge" donation types)
   *
   * @param double $recurringValue
   *
   * @return $this
   */
  public function setRecurringValue($recurringValue)
  {
    $this->recurringValue = $recurringValue;
    return $this;
  }

  /**
   * Number of payments that the customer wishes to split their pledge into. (Not required for "Recurring" donation
   * types)
   *
   * @return int
   */
  public function getNoOfPledgePayments()
  {
    return $this->noOfPledgePayments;
  }


  /**
   * Number of payments that the customer wishes to split their pledge into. (Not required for "Recurring" donation
   * types)
   *
   * @param int $noOfPledgePayments
   *
   * @return $this
   */
  public function setNoOfPledgePayments($noOfPledgePayments)
  {
    $this->noOfPledgePayments = $noOfPledgePayments;
    return $this;
  }

  /**
   * Frequency at which the paymentInterval should trigger the donation payment. (e.g. A paymentPeriod of 2 combined
   * with a "WEEKLY" paymentInterval will result in payment being taken every 2 weeks)
   *
   * @return int
   */
  public function getPaymentPeriod()
  {
    return $this->paymentPeriod;
  }


  /**
   * Frequency at which the paymentInterval should trigger the donation payment. (e.g. A paymentPeriod of 2 combined
   * with a "WEEKLY" paymentInterval will result in payment being taken every 2 weeks)
   *
   * @param int $paymentPeriod
   *
   * @return $this
   */
  public function setPaymentPeriod($paymentPeriod)
  {
    $this->paymentPeriod = $paymentPeriod;
    return $this;
  }

  /**
   * Frequency at which the customer wishes their regular donation to be performed. Allowed values : "WEEKLY",
   * "MONTHLY", "QUATERLY", "ANNUALLY"
   *
   * @return string
   */
  public function getPaymentInterval()
  {
    return $this->paymentInterval;
  }


  /**
   * Frequency at which the customer wishes their regular donation to be performed. Allowed values : "WEEKLY",
   * "MONTHLY", "QUATERLY", "ANNUALLY"
   *
   * @param string $paymentInterval
   *
   * @return $this
   */
  public function setPaymentInterval($paymentInterval)
  {
    $this->paymentInterval = $paymentInterval;
    return $this;
  }

  /**
   * Flag indicating that the customer wishes their payments to be processed manually (Only supported for "Pledge"
   * donation types)
   *
   * @return bool
   */
  public function getManualPayments()
  {
    return $this->manualPayments;
  }


  /**
   * Flag indicating that the customer wishes their payments to be processed manually (Only supported for "Pledge"
   * donation types)
   *
   * @param bool $manualPayments
   *
   * @return $this
   */
  public function setManualPayments($manualPayments)
  {
    $this->manualPayments = $manualPayments;
    return $this;
  }

  /**
   * Client defined option describing how manual payment will be taken
   *
   * @return string
   */
  public function getManualPaymentOptionMessage()
  {
    return $this->manualPaymentOptionMessage;
  }


  /**
   * Client defined option describing how manual payment will be taken
   *
   * @param string $manualPaymentOptionMessage
   *
   * @return $this
   */
  public function setManualPaymentOptionMessage($manualPaymentOptionMessage)
  {
    $this->manualPaymentOptionMessage = $manualPaymentOptionMessage;
    return $this;
  }

  /**
   * Client defined notes for the schedule.
   *
   * @return string
   */
  public function getNotes()
  {
    return $this->notes;
  }


  /**
   * Client defined notes for the schedule.
   *
   * @param string $notes
   *
   * @return $this
   */
  public function setNotes($notes)
  {
    $this->notes = $notes;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
