<?php
/**
 * Defines the RawViaApiPerformancePrice data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the details of a price band of a performance.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiPerformancePrice.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiPerformancePrice.
 */
abstract class RawViaApiPerformancePrice {

  /**
   * The id of this price band.
   *
   * @var int
   */
  protected $pricebandid;

  /**
   * The full price of this price band.
   *
   * @var string
   */
  protected $price;

  /**
   * The title of this price band.
   *
   * @var string
   */
  protected $pricetype;

  /**
   * Description of this price band
   *
   * @var string
   */
  protected $description;

  /**
   * The level of reservation for seats in this price band. Values are NONE (unreserved), AREA, BLOCK, ROW, SEAT.
   *
   * @var string
   */
  protected $priceBandReservationLevel;

  /**
   * Boolean indicating whether there are still seats available.
   *
   * @var bool
   */
  protected $seats;

  /**
   * An array of price concessions available for this price band.
   *
   * @var \Red61\Via\DataObject\ViaApiPriceConcession[]
   */
  protected $concessions;

  /**
   * If true then only concession purchase are permitted. Purchasing a full price ticket is not possible.
   *
   * @var bool
   */
  protected $hideFullPrice;

  /**
   * The percentage of seats remaining for sale from the original allocation. Returns NULL if there was no original
   * allocation to begin with.
   *
   * @var int
   */
  protected $seatPercentageRemaining;

  /**
   * A List `ViaApiFeeDetails` objects containing information on the fees that will be applied to tickets purchased for
   * this priceband. Note: field is `null` if no fees have been applied
   *
   * @var \Red61\Via\DataObject\ViaApiFeeDetails[]
   */
  protected $fees;

  /**
   * A flag indicating if tickets purchased for this priceband will be exempt from any event fees applied to the event.
   *
   * @var bool
   */
  protected $eventFeeExempt;

  /**
   * A flag indicating if tickets purchased for this priceband will be exempt from any handling fee calculations
   *
   * @var bool
   */
  protected $handlingFeeExempt;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'pricebandid':
        return $this->getPricebandid();
      case 'price':
        return $this->getPrice();
      case 'pricetype':
        return $this->getPricetype();
      case 'description':
        return $this->getDescription();
      case 'priceBandReservationLevel':
        return $this->getPriceBandReservationLevel();
      case 'seats':
        return $this->getSeats();
      case 'concessions':
        return $this->getConcessions();
      case 'hideFullPrice':
        return $this->getHideFullPrice();
      case 'seatPercentageRemaining':
        return $this->getSeatPercentageRemaining();
      case 'fees':
        return $this->getFees();
      case 'eventFeeExempt':
        return $this->getEventFeeExempt();
      case 'handlingFeeExempt':
        return $this->getHandlingFeeExempt();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The id of this price band.
   *
   * @return int
   */
  public function getPricebandid()
  {
    return $this->pricebandid;
  }


  /**
   * The full price of this price band.
   *
   * @return string
   */
  public function getPrice()
  {
    return $this->price;
  }


  /**
   * The title of this price band.
   *
   * @return string
   */
  public function getPricetype()
  {
    return $this->pricetype;
  }


  /**
   * Description of this price band
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * The level of reservation for seats in this price band. Values are NONE (unreserved), AREA, BLOCK, ROW, SEAT.
   *
   * @return string
   */
  public function getPriceBandReservationLevel()
  {
    return $this->priceBandReservationLevel;
  }


  /**
   * Boolean indicating whether there are still seats available.
   *
   * @return bool
   */
  public function getSeats()
  {
    return $this->seats;
  }


  /**
   * An array of price concessions available for this price band.
   *
   * @return \Red61\Via\DataObject\ViaApiPriceConcession[]
   */
  public function getConcessions()
  {
	return $this->concessions ? : array();
  }


  /**
   * If true then only concession purchase are permitted. Purchasing a full price ticket is not possible.
   *
   * @return bool
   */
  public function getHideFullPrice()
  {
    return $this->hideFullPrice;
  }


  /**
   * The percentage of seats remaining for sale from the original allocation. Returns NULL if there was no original
   * allocation to begin with.
   *
   * @return int
   */
  public function getSeatPercentageRemaining()
  {
    return $this->seatPercentageRemaining;
  }


  /**
   * A List `ViaApiFeeDetails` objects containing information on the fees that will be applied to tickets purchased for
   * this priceband. Note: field is `null` if no fees have been applied
   *
   * @return \Red61\Via\DataObject\ViaApiFeeDetails[]
   */
  public function getFees()
  {
	return $this->fees ? : array();
  }


  /**
   * A flag indicating if tickets purchased for this priceband will be exempt from any event fees applied to the event.
   *
   * @return bool
   */
  public function getEventFeeExempt()
  {
    return $this->eventFeeExempt;
  }


  /**
   * A flag indicating if tickets purchased for this priceband will be exempt from any handling fee calculations
   *
   * @return bool
   */
  public function getHandlingFeeExempt()
  {
    return $this->handlingFeeExempt;
  }


}
