<?php
/**
 * Defines the RawapiGetOrderIdForSessionIdRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Finds the order ID for any order created by the given session ID, if one exists
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetOrderIdForSessionIdRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetOrderIdForSessionIdRequest.
 */
abstract class RawapiGetOrderIdForSessionIdRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetOrderIdForSessionId';

  /**
   * session ID to search for orders by
   *
   * @var string
   */
  protected $orderSessionId;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * session ID to search for orders by
   *
   * @return string
   */
  public function getOrderSessionId()
  {
    return $this->orderSessionId;
  }


  /**
   * session ID to search for orders by
   *
   * @param string $orderSessionId
   *
   * @return $this
   */
  public function setOrderSessionId($orderSessionId)
  {
    $this->orderSessionId = $orderSessionId;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
