<?php
/**
 * Defines the RawapiGetBasketPrintOptionsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns a `ViaApiAvailablePrintOptionReturn` object containing a list of valid delivery options available calculated
 * against the current contents of the basket, also contains a String basketChangedMessage the presence of which
 * indicates that the basket's print option has been changed due to the basket contents not allowing the originally
 * selected print option. It is advisable to refresh the basket contents if this exception is populated.
 * 
 * Post is only available if all performance's in the basket are not after the `postCutOff` set and E-Ticket is only
 * available if all the sub venues in the basket are enabled for E-Ticket. Therefore these delivery options can change
 * after any basket contents change.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetBasketPrintOptionsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetBasketPrintOptionsRequest.
 */
abstract class RawapiGetBasketPrintOptionsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiGetBasketPrintOptions';

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * number of days before the earliest performance in the basket that post is still an option
   *
   * @var int
   */
  protected $postCutOff;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * number of days before the earliest performance in the basket that post is still an option
   *
   * @return int
   */
  public function getPostCutOff()
  {
    return $this->postCutOff;
  }


  /**
   * number of days before the earliest performance in the basket that post is still an option
   *
   * @param int $postCutOff
   *
   * @return $this
   */
  public function setPostCutOff($postCutOff)
  {
    $this->postCutOff = $postCutOff;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
