<?php
/**
 * Defines apiCreateOrderRequestSpec - specifications for Red61\Via\ApiRequest\apiCreateOrderRequest
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\ApiRequest;

use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\ApiRequest\apiCreateOrderRequest
 */
class apiCreateOrderRequestSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\ApiRequest\apiCreateOrderRequest
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\apiCreateOrderRequest');
	}

	function it_is_an_order_completing_request()
	{
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\OrderCompletingRequest');
	}

	function it_truncates_workstation_id_to_20_chars()
	{
		$this->subject
			->setWorkstationId('123456789012345678901')
			->getWorkstationId()->shouldBe('12345678901234567890');
	}

}
