<?php
/**
 * Defines the RawWheelchairUpdateException base exception class
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\Exception;

use \Red61\Via\Exception\ViaException;

/**
 * Exception is returned when BasketHelperBean has not been able to lock down the requested applications of wheelchair
 * products in the current basket.
 * 
 * NOTE: This is thrown in the default failure case if @BasketHelperBean fails due to an unexpected error then a
 * @NoOffersException is thrown
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\Exception\WheelchairUpdateException.
 *
 * @package    Red61\Via\RawGenerated\Exception
 * @see        \Red61\Via\Exception\WheelchairUpdateException.
 */
abstract class RawWheelchairUpdateException extends \SoapFault implements ViaException {


  public static function fromSoapFault(\SoapFault $fault)
  {
    $e = new static(
        $fault->faultcode,
        $fault->faultstring,
        $fault->faultactor,
        $fault->detail
    );

    return $e;
  }

}
