<?php
/**
 * Defines the ViaApiOrderDetails data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Wrapper Class returned by the methods:
 * <ol>
 * <li>{@link ViaApiEndpointJSE#apiCreateOrder(String, String, String, String, String, String, String, int, int,
 * String, int, String, String, boolean, String)}
 * <li>{@link ViaApiEndpointJSE#apiCreateInitialUnpaidOrder(String, String, String, String, String, String, int, int,
 * String, String)}
 * <li>{@link ViaApiEndpointJSE#apiCompleteOrder(int, boolean, String, String, String, String, String, String,
 * String, String, String)}
 * </ol>
 * 
 * Contains information on the result of the above calls.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiOrderDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiOrderDetails.
 */
abstract class ViaApiOrderDetails {

  /**
   * in the form 'LOCAL_SERVER_ID:entityId' where entityId is 'orderId' for methods:
   * <ol>
   * <li>{@link ViaApiEndpointJSE#apiCreateOrder(String, String, String, String, String, String, String, int, int,
   * String, int, String, String, boolean, String)}
   * <li>{@link ViaApiEndpointJSE#apiCompleteOrder(int, boolean, String, String, String, String, String, String,
   * String, String, String)}
   * </ol>
   * entityId is the 'paymentId' for the method:
   * <ol>
   * <li> {@link ViaApiEndpointJSE#apiCreateInitialUnpaidOrder(String, String, String, String, String, String,
   * int, int, String, String)}.
   * Red61 recommend using the '<code>sessionId|paymentId</code>' see
   * {@link ViaApiEndpointJSE#apiGetBasketSessionId(String)} for the payment tracking value.
   * </ol>
   * If the entityId is less than 0 then an error has occurred during these
   * critical order creation methods. If the entityId  is:
   * <ol>
   * <li>{@code -100 <= entityId <= -1} then server Error see {@link ViaApiEndpointJSE.OrderCode#SERVER_ERROR}
   * <li>{@code -200 <= entityId <= -101} then payment Error see {@link ViaApiEndpointJSE.OrderCode#PAYMENT_ERROR}
   * <li>{@code -300 <= entityId <= -201} then payment Setup Error see {@link
   * ViaApiEndpointJSE.OrderCode#PAYMENT_SETUP_NOT_ONLINE_ERROR} only if using independent Payment Processor
   * </ol>
   * If code = '-302' then this means redirect to url defined in statusmessage. This is only returned if additional
   * 3D secure authorisation is required, see {@link ViaApiEndpointJSE#apiCreateOrder(String, String, String, String,
   * String, String, String, int, int, String, int, String, String, boolean, String)}
   * for details.
   *
   * @var string
   */
  protected $code;

  /**
   * A message describing the result of the method call.
   *
   * @var string
   */
  protected $statusmessage;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'code':
        return $this->getCode();
      case 'statusmessage':
        return $this->getStatusmessage();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * in the form 'LOCAL_SERVER_ID:entityId' where entityId is 'orderId' for methods:
   * <ol>
   * <li>{@link ViaApiEndpointJSE#apiCreateOrder(String, String, String, String, String, String, String, int, int,
   * String, int, String, String, boolean, String)}
   * <li>{@link ViaApiEndpointJSE#apiCompleteOrder(int, boolean, String, String, String, String, String, String,
   * String, String, String)}
   * </ol>
   * entityId is the 'paymentId' for the method:
   * <ol>
   * <li> {@link ViaApiEndpointJSE#apiCreateInitialUnpaidOrder(String, String, String, String, String, String,
   * int, int, String, String)}.
   * Red61 recommend using the '<code>sessionId|paymentId</code>' see
   * {@link ViaApiEndpointJSE#apiGetBasketSessionId(String)} for the payment tracking value.
   * </ol>
   * If the entityId is less than 0 then an error has occurred during these
   * critical order creation methods. If the entityId  is:
   * <ol>
   * <li>{@code -100 <= entityId <= -1} then server Error see {@link ViaApiEndpointJSE.OrderCode#SERVER_ERROR}
   * <li>{@code -200 <= entityId <= -101} then payment Error see {@link ViaApiEndpointJSE.OrderCode#PAYMENT_ERROR}
   * <li>{@code -300 <= entityId <= -201} then payment Setup Error see {@link
   * ViaApiEndpointJSE.OrderCode#PAYMENT_SETUP_NOT_ONLINE_ERROR} only if using independent Payment Processor
   * </ol>
   * If code = '-302' then this means redirect to url defined in statusmessage. This is only returned if additional
   * 3D secure authorisation is required, see {@link ViaApiEndpointJSE#apiCreateOrder(String, String, String, String,
   * String, String, String, int, int, String, int, String, String, boolean, String)}
   * for details.
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


  /**
   * A message describing the result of the method call.
   *
   * @return string
   */
  public function getStatusmessage()
  {
    return $this->statusmessage;
  }


}
