<?php
/**
 * Defines the ViaApiEvent data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the details of a particular event.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiEvent.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiEvent.
 */
abstract class ViaApiEvent {

  /**
   * The reference of this event in the form "serverId:eventId".
   *
   * @var string
   */
  protected $id;

  /**
   * The title of this event.
   *
   * @var string
   */
  protected $title;

  /**
   * The description of this event.
   *
   * @var string
   */
  protected $description;

  /**
   * Unused.
   *
   * @var string
   */
  protected $status;

  /**
   * The title of this events genre.
   *
   * @var string
   */
  protected $type;

  /**
   * The title of this events sub genre.
   *
   * @var string
   */
  protected $subtype;

  /**
   * The title of this events venue.
   *
   * @var string
   */
  protected $venue;

  /**
   * The venue LatLong
   *
   * @var string
   */
  protected $venueLatLng;

  /**
   * The title of this events sub venue.
   *
   * @var string
   */
  protected $subvenue;

  /**
   * The title of this events promoter.
   *
   * @var string
   */
  protected $promoter;

  /**
   * The title of this events company.
   *
   * @var string
   */
  protected $company;

  /**
   * The reference of this events venue in the form "serverId:venueId".
   *
   * @var string
   */
  protected $venueid;

  /**
   * The reference of this events sub venue in the form "serverId:subvenueId".
   *
   * @var string
   */
  protected $subvenueid;

  /**
   * The reference of this events company in the form "serverId:companyId".
   *
   * @var string
   */
  protected $companyid;

  /**
   * The reference of this events promoter in the form "serverId:promoterId".
   *
   * @var string
   */
  protected $promoterid;

  /**
   * The server id of this event. Currently only populated when this object has been returned from a search method.
   *
   * @var int
   */
  protected $serverid;

  /**
   * The id of this events genre.
   *
   * @var int
   */
  protected $typeid;

  /**
   * The id of this events sub genre.
   *
   * @var int
   */
  protected $subtypeid;

  /**
   * The box office defined event code of this event. This may be null, but if defined will be unique within a given VIA
   * system
   *
   * @var string
   */
  protected $eventcode;

  /**
   * Any warnings for this event.
   *
   * @var string
   */
  protected $eventWarnings;

  /**
   * Related events are events which have been manually set as related to this event.
   *
   * @var \Red61\Via\DataObject\ViaApiListElement[]
   */
  protected $relatedEvents;

  /**
   * Suggested events are events that VIA itself has decided are similar to this event
   * based on the purchase history of this and other events.
   *
   * @var \Red61\Via\DataObject\ViaApiListElement[]
   */
  protected $suggestedEvents;

  /**
   * An array of the merchandise associated with this event.
   *
   * @var \Red61\Via\DataObject\ViaApiListElement[]
   */
  protected $relatedMerchandise;

  /**
   * An array of the donation funds associated with this event.
   *
   * @var \Red61\Via\DataObject\ViaApiListElement[]
   */
  protected $linkedDonationFunds;

  /**
   * An array of the event tags applied to this event.
   *
   * @var \Red61\Via\DataObject\ViaApiListElement[]
   */
  protected $eventTags;

  /**
   * subtitle of this event
   *
   * @var string
   */
  protected $subtitle;

  /**
   * The season code of the season associated to this event.
   *
   * @var string
   */
  protected $seasonCode;

  /**
   * The title of the season associated to this event.
   *
   * @var string
   */
  protected $seasonTitle;

  /**
   * A List of all of the custom event field entries for this event.
   *
   * @var \Red61\Via\DataObject\ViaApiCustomEventDetails[]
   */
  protected $customEventFields;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'id':
        return $this->getId();
      case 'title':
        return $this->getTitle();
      case 'description':
        return $this->getDescription();
      case 'status':
        return $this->getStatus();
      case 'type':
        return $this->getType();
      case 'subtype':
        return $this->getSubtype();
      case 'venue':
        return $this->getVenue();
      case 'venueLatLng':
        return $this->getVenueLatLng();
      case 'subvenue':
        return $this->getSubvenue();
      case 'promoter':
        return $this->getPromoter();
      case 'company':
        return $this->getCompany();
      case 'venueid':
        return $this->getVenueid();
      case 'subvenueid':
        return $this->getSubvenueid();
      case 'companyid':
        return $this->getCompanyid();
      case 'promoterid':
        return $this->getPromoterid();
      case 'serverid':
        return $this->getServerid();
      case 'typeid':
        return $this->getTypeid();
      case 'subtypeid':
        return $this->getSubtypeid();
      case 'eventcode':
        return $this->getEventcode();
      case 'eventWarnings':
        return $this->getEventWarnings();
      case 'relatedEvents':
        return $this->getRelatedEvents();
      case 'suggestedEvents':
        return $this->getSuggestedEvents();
      case 'relatedMerchandise':
        return $this->getRelatedMerchandise();
      case 'linkedDonationFunds':
        return $this->getLinkedDonationFunds();
      case 'eventTags':
        return $this->getEventTags();
      case 'subtitle':
        return $this->getSubtitle();
      case 'seasonCode':
        return $this->getSeasonCode();
      case 'seasonTitle':
        return $this->getSeasonTitle();
      case 'customEventFields':
        return $this->getCustomEventFields();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of this event in the form "serverId:eventId".
   *
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }


  /**
   * The title of this event.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The description of this event.
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * Unused.
   *
   * @return string
   */
  public function getStatus()
  {
    return $this->status;
  }


  /**
   * The title of this events genre.
   *
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }


  /**
   * The title of this events sub genre.
   *
   * @return string
   */
  public function getSubtype()
  {
    return $this->subtype;
  }


  /**
   * The title of this events venue.
   *
   * @return string
   */
  public function getVenue()
  {
    return $this->venue;
  }


  /**
   * The venue LatLong
   *
   * @return string
   */
  public function getVenueLatLng()
  {
    return $this->venueLatLng;
  }


  /**
   * The title of this events sub venue.
   *
   * @return string
   */
  public function getSubvenue()
  {
    return $this->subvenue;
  }


  /**
   * The title of this events promoter.
   *
   * @return string
   */
  public function getPromoter()
  {
    return $this->promoter;
  }


  /**
   * The title of this events company.
   *
   * @return string
   */
  public function getCompany()
  {
    return $this->company;
  }


  /**
   * The reference of this events venue in the form "serverId:venueId".
   *
   * @return string
   */
  public function getVenueid()
  {
    return $this->venueid;
  }


  /**
   * The reference of this events sub venue in the form "serverId:subvenueId".
   *
   * @return string
   */
  public function getSubvenueid()
  {
    return $this->subvenueid;
  }


  /**
   * The reference of this events company in the form "serverId:companyId".
   *
   * @return string
   */
  public function getCompanyid()
  {
    return $this->companyid;
  }


  /**
   * The reference of this events promoter in the form "serverId:promoterId".
   *
   * @return string
   */
  public function getPromoterid()
  {
    return $this->promoterid;
  }


  /**
   * The server id of this event. Currently only populated when this object has been returned from a search method.
   *
   * @return int
   */
  public function getServerid()
  {
    return $this->serverid;
  }


  /**
   * The id of this events genre.
   *
   * @return int
   */
  public function getTypeid()
  {
    return $this->typeid;
  }


  /**
   * The id of this events sub genre.
   *
   * @return int
   */
  public function getSubtypeid()
  {
    return $this->subtypeid;
  }


  /**
   * The box office defined event code of this event. This may be null, but if defined will be unique within a given VIA
   * system
   *
   * @return string
   */
  public function getEventcode()
  {
    return $this->eventcode;
  }


  /**
   * Any warnings for this event.
   *
   * @return string
   */
  public function getEventWarnings()
  {
    return $this->eventWarnings;
  }


  /**
   * Related events are events which have been manually set as related to this event.
   *
   * @return \Red61\Via\DataObject\ViaApiListElement[]
   */
  public function getRelatedEvents()
  {
	return $this->relatedEvents ? : array();
  }


  /**
   * Suggested events are events that VIA itself has decided are similar to this event
   * based on the purchase history of this and other events.
   *
   * @return \Red61\Via\DataObject\ViaApiListElement[]
   */
  public function getSuggestedEvents()
  {
	return $this->suggestedEvents ? : array();
  }


  /**
   * An array of the merchandise associated with this event.
   *
   * @return \Red61\Via\DataObject\ViaApiListElement[]
   */
  public function getRelatedMerchandise()
  {
	return $this->relatedMerchandise ? : array();
  }


  /**
   * An array of the donation funds associated with this event.
   *
   * @return \Red61\Via\DataObject\ViaApiListElement[]
   */
  public function getLinkedDonationFunds()
  {
	return $this->linkedDonationFunds ? : array();
  }


  /**
   * An array of the event tags applied to this event.
   *
   * @return \Red61\Via\DataObject\ViaApiListElement[]
   */
  public function getEventTags()
  {
	return $this->eventTags ? : array();
  }


  /**
   * subtitle of this event
   *
   * @return string
   */
  public function getSubtitle()
  {
    return $this->subtitle;
  }


  /**
   * The season code of the season associated to this event.
   *
   * @return string
   */
  public function getSeasonCode()
  {
    return $this->seasonCode;
  }


  /**
   * The title of the season associated to this event.
   *
   * @return string
   */
  public function getSeasonTitle()
  {
    return $this->seasonTitle;
  }


  /**
   * A List of all of the custom event field entries for this event.
   *
   * @return \Red61\Via\DataObject\ViaApiCustomEventDetails[]
   */
  public function getCustomEventFields()
  {
	return $this->customEventFields ? : array();
  }


}
