<?php
/**
 * Defines the apiSendToAFriendRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to fetch a unique transaction token for a set of items from a transaction. This token can be used
 * to claim the items by  calling {@link #apiClaimFromFriend(java.lang.String, java.lang.String, int, java.lang.String)
 * }
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSendToAFriendRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSendToAFriendRequest.
 */
abstract class apiSendToAFriendRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiSendToAFriend';

  /**
   * The unique set of sold items from a transaction
   *
   * @var int[]
   */
  protected $items;

  /**
   * The ID of the transaction that the items belong to
   *
   * @var string
   */
  protected $orderId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The unique set of sold items from a transaction
   *
   * @return int[]
   */
  public function getItems()
  {
    return $this->items;
  }


  /**
   * The unique set of sold items from a transaction
   *
   * @param int[] $items
   *
   * @return $this
   */
  public function setItems($items)
  {
    $this->items = $items;
    return $this;
  }

  /**
   * The ID of the transaction that the items belong to
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * The ID of the transaction that the items belong to
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
