<?php
/**
 * Defines the apiSend3DSecureReturnRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * For completing the 3-D secure process. If {@link #apiCreateOrder(String, String, String, String, String, String,
 * String, int, int, String, int, String, String, boolean, String)}  returns a re-direct and code of 'serverId:-302'
 * then the card being processed requires extra 3-D secure authorisation -   currently only Maestro cards require 3-D
 * secure authorisation.   The resulting <code>md</code> and <code>paRes</code> fields must be passed to this call to
 * complete the 3-D secure transaction and, if payment  succeeds, this call will complete the order and 'remove' the
 * basket.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSend3DSecureReturnRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSend3DSecureReturnRequest.
 */
abstract class apiSend3DSecureReturnRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiSend3DSecureReturn';

  /**
   * 3D secure field - MD Unique reference used by all parties including SECPay and the merchant to identify and track
   * the 3-D Secure transaction
   *
   * @var string
   */
  protected $md;

  /**
   * 3D secure field - PARes Payer Authentication Response. 3-D Secure Protocol message type. This is the response
   * returned after submitting a PAReq. It indicates whether or not the cardholder passed 3-D Secure authentication.
   *
   * @var string
   */
  protected $paRes;

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * 3D secure field - MD Unique reference used by all parties including SECPay and the merchant to identify and track
   * the 3-D Secure transaction
   *
   * @return string
   */
  public function getMd()
  {
    return $this->md;
  }


  /**
   * 3D secure field - MD Unique reference used by all parties including SECPay and the merchant to identify and track
   * the 3-D Secure transaction
   *
   * @param string $md
   *
   * @return $this
   */
  public function setMd($md)
  {
    $this->md = $md;
    return $this;
  }

  /**
   * 3D secure field - PARes Payer Authentication Response. 3-D Secure Protocol message type. This is the response
   * returned after submitting a PAReq. It indicates whether or not the cardholder passed 3-D Secure authentication.
   *
   * @return string
   */
  public function getPaRes()
  {
    return $this->paRes;
  }


  /**
   * 3D secure field - PARes Payer Authentication Response. 3-D Secure Protocol message type. This is the response
   * returned after submitting a PAReq. It indicates whether or not the cardholder passed 3-D Secure authentication.
   *
   * @param string $paRes
   *
   * @return $this
   */
  public function setPaRes($paRes)
  {
    $this->paRes = $paRes;
    return $this;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
