<?php
/**
 * Defines the apiRemoveRepeatabilityCustomerSavedCardRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to stop a customer's card from a previous payment from being included in the list of repeat
 * payments for a customer, see {@link #apiGetCustomerSavedCards(java.lang.Integer, java.lang.String)}  If this call is
 * successful then calling {@link #apiGetCustomerSavedCards(java.lang.Integer, java.lang.String)} should no longer
 * contain the repeat payment identified by {@code repeatPaymentToken}
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiRemoveRepeatabilityCustomerSavedCardRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiRemoveRepeatabilityCustomerSavedCardRequest.
 */
abstract class apiRemoveRepeatabilityCustomerSavedCardRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiRemoveRepeatabilityCustomerSavedCard';

  /**
   * The ID of the customer that is linked to this repeat payment token
   *
   * @var int
   */
  protected $customerId;

  /**
   * A repeat payment token for this customer that needs to have its repeatability removed. This is the field {@link
   * ViaApiSavedCardDetails#id}
   *
   * @var string
   */
  protected $repeatPaymentToken;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The ID of the customer that is linked to this repeat payment token
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The ID of the customer that is linked to this repeat payment token
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * A repeat payment token for this customer that needs to have its repeatability removed. This is the field {@link
   * ViaApiSavedCardDetails#id}
   *
   * @return string
   */
  public function getRepeatPaymentToken()
  {
    return $this->repeatPaymentToken;
  }


  /**
   * A repeat payment token for this customer that needs to have its repeatability removed. This is the field {@link
   * ViaApiSavedCardDetails#id}
   *
   * @param string $repeatPaymentToken
   *
   * @return $this
   */
  public function setRepeatPaymentToken($repeatPaymentToken)
  {
    $this->repeatPaymentToken = $repeatPaymentToken;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
