<?php
/**
 * Defines the apiGetEventDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns the event details for a given event.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetEventDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetEventDetailsRequest.
 */
abstract class apiGetEventDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetEventDetails';

  /**
   * The serverId and eventId to return information for in the form "serverId:eventId"
   *
   * @var string
   */
  protected $eventRef;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The serverId and eventId to return information for in the form "serverId:eventId"
   *
   * @return string
   */
  public function getEventRef()
  {
    return $this->eventRef;
  }


  /**
   * The serverId and eventId to return information for in the form "serverId:eventId"
   *
   * @param string $eventRef
   *
   * @return $this
   */
  public function setEventRef($eventRef)
  {
    $this->eventRef = $eventRef;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
