<?php
/**
 * Defines the apiGetDonationsForEventRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns a list of the donation funds linked to a specific event
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetDonationsForEventRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetDonationsForEventRequest.
 */
abstract class apiGetDonationsForEventRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetDonationsForEvent';

  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @var string
   */
  protected $eventRef;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @return string
   */
  public function getEventRef()
  {
    return $this->eventRef;
  }


  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @param string $eventRef
   *
   * @return $this
   */
  public function setEventRef($eventRef)
  {
    $this->eventRef = $eventRef;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
