<?php
/**
 * Defines the apiEventQuickSearchRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Searches for events based on a supplied keyword. Matches are based   on:   <ul>  	<li>event titles;
 * <li>performance dates;    	<li>venue names;   	<li>sub venue names;   	<li>companies;   	<li>artists;
 * <li>promoters;    	<li>performance dates (DD/MM/YY)  </ul>
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiEventQuickSearchRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiEventQuickSearchRequest.
 */
abstract class apiEventQuickSearchRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiEventQuickSearch';

  /**
   * the search term
   *
   * @var string
   */
  protected $keyword;

  /**
   * 
   *
   * @var bool
   */
  protected $quickSearch;

  /**
   * the authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the search term
   *
   * @return string
   */
  public function getKeyword()
  {
    return $this->keyword;
  }


  /**
   * the search term
   *
   * @param string $keyword
   *
   * @return $this
   */
  public function setKeyword($keyword)
  {
    $this->keyword = $keyword;
    return $this;
  }

  /**
   * 
   *
   * @return bool
   */
  public function getQuickSearch()
  {
    return $this->quickSearch;
  }


  /**
   * 
   *
   * @param bool $quickSearch
   *
   * @return $this
   */
  public function setQuickSearch($quickSearch)
  {
    $this->quickSearch = $quickSearch;
    return $this;
  }

  /**
   * the authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * the authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
