<?php
/**
 * Defines the apiCreateReservationRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Creates a reservation with the items in the given basket for the given customer.  This call may fail for several
 * reasons. Reason for failure will be indicated in the returned objects code and  status messages. Calls may fail for
 * the following reasons.  <ul>  <li>The web user does not have permission to create reservations.</li>  <li>The basket
 * contains non ticket items.</li>  <li>The user does not have permission to reserve one or more items in the
 * basket.</li>  <li>One or more of the tickets in the basket are no longer on sale.</li>  <li>The given customer is not
 * valid.</li>  </ul>
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCreateReservationRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCreateReservationRequest.
 */
abstract class apiCreateReservationRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiCreateReservation';

  /**
   * The id of the customer making the reservation.
   *
   * @var int
   */
  protected $customerId;

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer making the reservation.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer making the reservation.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
