<?php
/**
 * Base interface for all VIA exceptions
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\Exception;

/**
 * This interface is implemented by all exceptions thrown by the VIA wrapper, and can be used as a generic/fallback
 * `catch` block for any code that accesses the API.
 *
 * [!!] Legacy code may have been written to catch \SoapFault as the fallback case - we recommend instead catching
 *      ViaException or better yet one of the specific exception classes you are interested in. Future wrapper versions
 *      may introduce new exceptions that do not extend from \SoapFault.
 *
 * @package Red61\Via\Exception
 */
interface ViaException {

} 
