<?php
/**
 * Defines the apiLoginRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\ApiRequest;
use Red61\Via\Exception\ClientInvalidRequestException;
use Red61\Via\Plugin\ViaApiCallNotification;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiLoginRequest
	extends \Red61\Via\RawGenerated\ApiRequest\apiLoginRequest
	implements PreflightFilteringRequest {

	/**
	 * {@inheritdoc}
	 */
	public function onBeforeViaCall(ViaApiCallNotification $notification)
	{
		if ($errors = $this->buildEmptyFieldErrorsFor(array('email', 'password'))) {
			throw new ClientInvalidRequestException($this, $errors);
		}
	}

}
