<?php
/**
 * Defines the apiCreateRepeatPaymentOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\ApiRequest;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiCreateRepeatPaymentOrderRequest
	extends \Red61\Via\RawGenerated\ApiRequest\apiCreateRepeatPaymentOrderRequest
	implements OrderCompletingRequest {

	/**
	 * Sets the value, truncating to 20 characters
	 * {@inheritdoc}
	 */
	public function setWorkstationId($workstationId)
	{
		return parent::setWorkstationId(substr($workstationId, 0, 20));
	}

}
