<?php
/**
 * Defines the CacheTTLOverridingRequest interface
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;

/**
 * Implement this method if the request should set a different TTL based on some request
 * property or external state that it is aware of.
 *
 * @package Red61\Via\ApiRequest
 */
interface CacheTTLOverridingRequest {

	/**
	 * Return the cache TTL that should be used for this request, in seconds
	 *
	 * @return int
	 */
	public function getCacheTtl();
}
