<?php
/**
 * Defines ViaApiEventSpec - specifications for Red61\Via\DataObject\ViaApiEvent
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\DataObject;

use spec\ObjectBehavior;
use Prophecy\Argument;
use spec\Support\SubjectProtectedPropertySetter;

/**
 *
 * @see Red61\Via\DataObject\ViaApiEvent
 */
class ViaApiEventSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\DataObject\ViaApiEvent
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\DataObject\ViaApiEvent');
	}

	function it_strips_html_body_tags_from_description()
	{
		SubjectProtectedPropertySetter::for_subject($this->subject)
			->set_values(array(
				'description' => '<body>Some description of the event</body>'
			));

		$this->subject->getDescription()->shouldBe('Some description of the event');
	}

	function it_leaves_description_without_body_tags_unchanged()
	{
		SubjectProtectedPropertySetter::for_subject($this->subject)
			->set_values(array(
				'description' => '<p>Some description of the event</p>'
			));

		$this->subject->getDescription()->shouldBe('<p>Some description of the event</p>');
	}


}
