<?php
/**
 * Defines apiGetSeatingPlanRequestSpec - specifications for Red61\Via\ApiRequest\apiGetSeatingPlanRequest
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\ApiRequest;

use spec\ObjectBehavior;
use Prophecy\Argument;
use spec\Support\SubjectProtectedPropertySetter;

/**
 *
 * @see Red61\Via\ApiRequest\apiGetSeatingPlanRequest
 */
class apiGetSeatingPlanRequestSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\ApiRequest\apiGetSeatingPlanRequest
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\apiGetSeatingPlanRequest');
	}

	function it_is_a_cache_ttl_overriding_request()
	{
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\CacheTTLOverridingRequest');
	}

	function it_caches_for_five_seconds_with_a_lastUpdate_parameter()
	{
		$this->subject->setLastUpdate(10)
			->getCacheTtl()->shouldBe(5);
	}

	function it_caches_for_300_seconds_without_a_lastUpdate_parameter()
	{
		$this->subject->getCacheTtl()->shouldBe(300);
	}


}
