<?php
/**
 * Defines Red61\Via\Cache\ViaCacheKeyGenerator
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace Red61\Via\Cache;

use Red61\Via\ApiRequest\ViaApiRequest;

/**
 * Responsible for producing unique cache keys for API requests
 *
 * @package Red61\Via\Cache
 * @see     spec\Red61\Via\Cache\ViaCacheKeyGeneratorSpec
 */
class ViaCacheKeyGenerator
{

    /**
     * @param ViaApiRequest $request
     *
     * @return string
     */
    public function get_key(ViaApiRequest $request)
    {
        $params = serialize($request);

        // Some caches e.g. memcache have a maximum key length. We therefore use a hash of the request
        // parameters to ensure a predictable length and restricted character set. To minimise the
        // risk of a hash collision we combine md5 and sha1 on the basis it's highly unlikely that
        // a single value could produce a collision in both algorithms simultaneously.

        return $request->getSoapMethodName().'-'.md5($params).'-'.sha1($params);
    }
}
