<?php
/**
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */
namespace Red61\Via\SessionStorage;


/**
 * Optionally, use a ViaSessionStorage implementation to track the user's basket ID across requests. This
 * saves your having to implement suitable shutdown or post-call handlers to detect when a user's basket ID has
 * changed.
 *
 * Pass an instance to the connectSessionStorage method on the ViaApiClient to activate your chosen storage engine.
 *
 * **[!!] Important: managing session concurrency**
 * It is critical that your session storage implementation has adequate protection against concurrent requests
 * from the same user. See the documentation for more information.
 *
 * @package Red61\Via\SessionStorage
 * @see     spec\Red61\Via\SessionStorage\PhpNativeSessionStorageSpec
 */
interface ViaSessionStorage
{
	/**
	 * Load the current basket ID from storage. This will be called when the storage instance is first assigned to a
	 * ViaApiClient.
	 *
	 * @return string the basket ID that was previously persisted
	 */
	public function loadBasketId();

	/**
	 * Save a new basket ID value in the storage engine.
	 *
	 * [!!] The basket_id parameter is not guaranteed to be different to the currently stored value. In particular,
	 *      saveBasketId will be called shortly after loadBasketId when the session storage is first connected.
	 *      If you are using database or similar storage, you may wish to cache the last loaded value in your
	 *      implementation and only write to the database if it is different.
	 *
	 * @param string $basket_id the current basket ID (or NULL if no basket)
	 *
	 * @return void
	 */
	public function saveBasketId($basket_id);
}
