<?php
/**
 * Thrown if a cache connection cannot be created for some reason
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2013 Edinburgh International Book Festival
 * @licence   proprietary
 */

namespace Red61\Via\Exception;

/**
 * Thrown if a cache connection cannot be opened
 *
 * [!!] This exception extends \SoapFault for legacy compatibility reasons, but is likely
 *      in future to change to extend a more suitable base class.
 *
 * @package Red61\Via\Exception
 */
class CacheNotAvailableException extends \SoapFault implements ViaException {

	/**
	 * @param string $message
	 */
	public function __construct($message)
	{
		parent::__construct('Client', $message);
	}
} 
