<?php
/**
 * Defines Red61\Via\CircuitBreaker\ViaCircuitBreakerListener
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Edinburgh International Book Festival Ltd
 * @licence   http://opensource.org/licenses/BSD-3-Clause
 */

namespace Red61\Via\CircuitBreaker;

/**
 * Implement this interface if you want to receive notifications when the circuit breaker
 * trips or resets - for example to log, to alert administrators or otherwise. See the
 * package README.md for complete documentation.
 *
 * @package Red61\Via\CircuitBreaker
 */
interface ViaCircuitBreakerListener {

	/**
	 * @return void
	 */
	public function onCallBlocked();

	/**
	 * @param string     $tripping_severity
	 * @param \Exception $tripping_fault
	 * @param int        $error_rate
	 *
	 * @return void
	 */
	public function onTripped($tripping_severity, \Exception $tripping_fault, $error_rate);

	/**
	 * @return void
	 */
	public function onReset();
} 
